/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CqnService;

import java.util.Map;

/**
 * Implementation for specialized {@link EventContext} to be used for {@link CqnService#EVENT_READ}
 */
public class CdsReadEventContextImpl extends EventContextDelegator implements CdsReadEventContext {

	public CdsReadEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public CqnService getService() {
		return (CqnService) super.getService();
	}

	private static final String PARAM_CQN = "cqn";
	private static final String PARAM_CQN_NAME_VALUES = "cqnNamedValues";
	private static final String PARAM_RESULT = "result";

	// IN
	public CqnSelect getCqn() {
		return (CqnSelect)get(PARAM_CQN);
	}

	public void setCqn(CqnSelect cqn) {
		put(PARAM_CQN, cqn);
	}

	@SuppressWarnings("unchecked")
	public Map<String, Object> getCqnNamedValues(){
		return (Map<String,Object>)get(PARAM_CQN_NAME_VALUES);
	}

	public void setCqnNamedValues(Map<String, Object> namedValues) {
		put(PARAM_CQN_NAME_VALUES, namedValues);
	}

	// OUT
	public Result getResult() {
		return (Result)get(PARAM_RESULT);
	}

	public void setResult(Iterable<? extends Map<String, ?>> result) {
		put(PARAM_RESULT, ResultUtils.convert(result));
		setCompleted();
	}

}
