/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CqnService;

import java.util.Map;

/**
 * Implementation for specialized {@link EventContext} to be used for {@link CqnService#EVENT_UPDATE}
 */
public class CdsUpdateEventContextImpl extends EventContextDelegator implements CdsUpdateEventContext {

	public CdsUpdateEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public CqnService getService() {
		return (CqnService)super.getService();
	}

	private static final String PARAM_CQN = "cqn";
	private static final String PARAM_CQN_VALUE_SETS = "cqnValueSets";
	private static final String PARAM_RESULT = "result";

	// IN
	public CqnUpdate getCqn() {
		return (CqnUpdate)get(PARAM_CQN);
	}

	public void setCqn(CqnUpdate cqn) {
		put(PARAM_CQN, cqn);
	}

	@SuppressWarnings("unchecked")
	public Iterable<Map<String, Object>> getCqnValueSets() {
		return (Iterable<Map<String, Object>>)get(PARAM_CQN_VALUE_SETS);
	}

	public void setCqnValueSets(Iterable<Map<String, Object>> valueSets) {
		put(PARAM_CQN_VALUE_SETS, valueSets);
	}

	// OUT
	public Result getResult() {
		return (Result)get(PARAM_RESULT);
	}

	public void setResult(Iterable<? extends Map<String, ?>> result) {
		put(PARAM_RESULT, ResultUtils.convert(result));
		setCompleted();
	}
}
