/**************************************************************************
 * (C) 2019-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.NotNullHandlerDelegate;
import com.sap.cds.services.utils.OrderConstants;

/**
 * Handler class to check not null elements on non-standard events, e.g. functions or actions.
 */
@ServiceName(value = "*", type = ApplicationService.class)
public class NotNullHandler implements EventHandler {

	private final NotNullHandlerDelegate delegate = new NotNullHandlerDelegate();

	@Before
	@HandlerOrder(OrderConstants.Before.VALIDATE_FIELDS)
	public void runCheck(EventContext context) {
		if (!CdsModelUtils.isStandardCdsEvent(context.getEvent())) {
			delegate.accept(context, true);
		}
	}
}
