/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
/**
 *
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;

import java.util.Map;

/**
 * Implementation of the {@link EventContext} for the {@link DraftService#EVENT_DRAFT_CREATE} event.
 */
public class DraftCreateEventContextImpl extends EventContextDelegator implements DraftCreateEventContext {

	public DraftCreateEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}
	
	@Override
	public DraftService getService() {
		return (DraftService) super.getService();
	}

	private static final String PARAM_CQN = "cqn";
	private static final String PARAM_RESULT = "result";

	// IN
	/**
	 * @return the {@link CqnInsert} statement
	 */
	public CqnInsert getCqn() {
		return (CqnInsert)get(PARAM_CQN);
	}

	/**
	 * Sets the {@link CqnInsert} statement
	 * @param cqn the {@link CqnInsert} statement
	 */
	public void setCqn(CqnInsert cqn) {
		put(PARAM_CQN, cqn);
	}

	// OUT
	/**
	 * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_CREATE} event
	 */
	public Result getResult() {
		return (Result)get(PARAM_RESULT);
	}

	/**
	 * Sets the result of the {@link DraftService#EVENT_DRAFT_CREATE} event
	 * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link Result}
	 */
	public void setResult(Iterable<? extends Map<String, ?>> result) {
		put(PARAM_RESULT, ResultUtils.convert(result));
		setCompleted();
	}

}
