package com.sap.cds.services.impl.environment;

import java.util.List;
import java.util.Map;

import com.sap.cds.services.environment.ServiceBinding;

/**
 * Adapts a {@link com.sap.cloud.environment.servicebinding.api.ServiceBinding} to a {@link ServiceBinding}
 */
public class ServiceBindingAdapter implements ServiceBinding {

	private final com.sap.cloud.environment.servicebinding.api.ServiceBinding binding;

	public ServiceBindingAdapter(com.sap.cloud.environment.servicebinding.api.ServiceBinding binding) {
		this.binding = binding;
	}

	@Override
	public String getName() {
		return binding.getName().orElse(null);
	}

	@Override
	public String getService() {
		return binding.getServiceName().orElse(null);
	}

	@Override
	public String getServicePlan() {
		return binding.getServicePlan().orElse(null);
	}

	@Override
	public List<String> getTags() {
		return binding.getTags();
	}

	@Override
	public Map<String, Object> getCredentials() {
		return binding.getCredentials();
	}

}
