/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.mtx.impl.ModelProviderAccess;
import com.sap.cds.mtx.impl.SidecarAccessV1;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;

public class DynamicModelProviderConfiguration implements CdsRuntimeConfiguration {

	private static final Logger logger = LoggerFactory.getLogger(DynamicModelProviderConfiguration.class);

	@Override
	public void providers(CdsRuntimeConfigurer configurer) {
		DynamicModelUtils utils = new DynamicModelUtils(configurer.getCdsRuntime());
		if (utils.isDynamicModelEnabled()) {
			logger.info("Loading DynamicModelProvider");
			configurer.provider(new DynamicModelProvider(configurer.getCdsRuntime()));

			DefaultHttpDestination destination = DefaultHttpDestination.builder(utils.getModelProviderUrl())
					.name(utils.isModelProviderEnabled() ? ModelProviderAccess.MODEL_PROVIDER_DESTINATION : SidecarAccessV1.MTX_SIDECAR_DESTINATION)
					.build();

			// TODO sync with other destinations
			DefaultDestinationLoader destinationLoader = new DefaultDestinationLoader();
			destinationLoader.registerDestination(destination);
			DestinationAccessor.prependDestinationLoader(destinationLoader);
		}
	}

}
