package com.sap.cds.services.impl.outbox;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.outbox.AbstractOutboxService;

public class InMemoryOutbox extends AbstractOutboxService {

	private static final Logger logger = LoggerFactory.getLogger(InMemoryOutbox.class);

	public InMemoryOutbox(String name) {
		super(name);
	}

	@Override
	protected void enroll(OutboxMessageEventContext context) {
		logger.debug("Enrolling outbox message with target event '{}'", context.getEvent());
		boolean emitDuringChangeSetContext = context.getCdsRuntime().getEnvironment().getCdsProperties().getOutbox().getInMemory().isEmitDuringChangeSetContext();

		ChangeSetContext changeSet = context.getChangeSetContext();

		changeSet.register(new ChangeSetListener() {
			@Override
			public void beforeClose() {
				if (!changeSet.isMarkedForCancel() && emitDuringChangeSetContext) {
					publishMessage(context);
				}
			}

			@Override
			public void afterClose(boolean completed) {
				if (!emitDuringChangeSetContext && completed) {
					publishMessage(context);
				}
			}
		});
	}

	private void publishMessage(OutboxMessageEventContext enrollContext) throws ErrorStatusException {
		logger.debug("Publishing outbox message with target event '{}'", enrollContext.getEvent());
		OutboxMessageEventContext publishContext = OutboxMessageEventContext.create(enrollContext.getEvent());
		publishContext.setIsInbound(true);
		publishContext.setTimestamp(enrollContext.getTimestamp());
		publishContext.setMessage(enrollContext.getMessage());
		enrollContext.getService().emit(publishContext);
	}

}
