/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.impl.outbox.persistence.PersistentOutbox;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutboxInitializationHandler;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.outbox.OutboxUtils;

public class OutboxServiceConfiguration implements CdsRuntimeConfiguration {

	@Override
	public void services(CdsRuntimeConfigurer configurer) {
		if (isPersistentOutboxConfigured(configurer.getCdsRuntime())) {
			configurer.service(
					new PersistentOutbox(OutboxService.PERSISTENT_NAME, configurer.getCdsRuntime()));
		}

		if (configurer.getCdsRuntime().getEnvironment().getCdsProperties().getOutbox().getInMemory().isEnabled()) {
			configurer.service(new InMemoryOutbox(OutboxService.INMEMORY_NAME));
		}
	}

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		if (isPersistentOutboxConfigured(configurer.getCdsRuntime())) {
			configurer.eventHandler(new PersistentOutboxInitializationHandler());
		}
	}

	private boolean isPersistentOutboxConfigured(CdsRuntime runtime) {
		return runtime.getEnvironment().getCdsProperties().getOutbox().getPersistent().isEnabled()
				&& OutboxUtils.hasOutboxModel(runtime.getCdsModel());
	}
}
