package com.sap.cds.services.impl.outbox.persistence;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class PersistentOutboxInitializationHandler implements EventHandler {

	@After
	protected void initCollector(ApplicationPreparedEventContext context) {
		if (context.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled()) {
			return;
		}

		context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::init);
	}

	@On
	protected void stopCollector(ApplicationStoppedEventContext context) {
		context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::stop);
	}

}
