/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.impl.utils.DeveloperModeUtils;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public class ContextualizedServiceException
extends ServiceException {
    private static final long serialVersionUID = 1L;
    private final EventContext errorContext;
    private final List<EventContext> viaList = new ArrayList<EventContext>();

    public ContextualizedServiceException(EventContext context, Throwable cause) {
        super(null, new Object[]{cause});
        this.errorContext = context;
    }

    public void via(EventContext context) {
        this.viaList.add(context);
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        String nearestMessage = this.getNearest(t -> t.getMessage());
        builder.append(nearestMessage == null ? "<no message>" : nearestMessage);
        if (this.errorContext != null) {
            Service service = this.errorContext.getService();
            String event = this.errorContext.getEvent();
            CdsEntity entity = this.errorContext.getTarget();
            builder.append(" (service '").append(service == null ? "<no service>" : service.getName()).append("', ");
            builder.append("event '").append(event == null ? "<no event>" : event).append("', ");
            builder.append("entity '").append(entity == null ? "<no entity>" : entity.getQualifiedName()).append("')");
        }
        if (Utils.getErrorsProperties().isExtended()) {
            DeveloperModeUtils.extendMessage(builder, this);
        }
        return builder.toString();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getNearest(t -> {
            if (t instanceof ServiceException) {
                return ((ServiceException)((Object)t)).getLocalizedMessage(locale);
            }
            if (t.getLocalizedMessage() != null) {
                boolean stackMessages = Utils.getErrorsProperties().getStackMessages().isEnabled();
                if (!stackMessages) {
                    return new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale);
                }
                return t.getLocalizedMessage();
            }
            return null;
        });
    }

    public String getPlainMessage() {
        return this.getNearest(t -> {
            if (t instanceof ServiceException) {
                return ((ServiceException)((Object)t)).getPlainMessage();
            }
            return t.getMessage();
        });
    }

    public ErrorStatus getErrorStatus() {
        ErrorStatus theErrorStatus = this.getNearest(t -> {
            if (t instanceof ServiceException) {
                return ((ServiceException)((Object)t)).getErrorStatus();
            }
            return null;
        });
        return theErrorStatus == null ? ErrorStatuses.SERVER_ERROR : theErrorStatus;
    }

    public MessageTarget getMessageTarget() {
        return this.getNearest(t -> {
            if (t instanceof ServiceException) {
                return ((ServiceException)((Object)t)).getMessageTarget();
            }
            return null;
        });
    }

    public EventContext getErrorContext() {
        return this.errorContext;
    }

    public List<EventContext> getViaList() {
        return this.viaList;
    }

    protected List<EventContext> collectEventContexts() {
        ContextualizedServiceException previous = null;
        for (Throwable cause = this.getCause(); previous == null && cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ContextualizedServiceException)) continue;
            previous = (ContextualizedServiceException)((Object)cause);
        }
        ArrayList<EventContext> result = new ArrayList<EventContext>();
        if (previous != null) {
            result.addAll(previous.collectEventContexts());
        }
        result.add(this.errorContext);
        result.addAll(this.viaList);
        return result;
    }

    private <T> T getNearest(Function<Throwable, T> provider) {
        T value = null;
        for (Throwable cause = this.getCause(); value == null && cause != null; cause = cause.getCause()) {
            if (cause instanceof ContextualizedServiceException) continue;
            value = provider.apply(cause);
        }
        return value;
    }
}

