/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.impl.auditlog.PersonalDataUtils;
import com.sap.cds.services.impl.utils.TargetAwareCqnModifier;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

class PersonalDataModifier
extends TargetAwareCqnModifier {
    private final List<PersonalDataModifier> children = new LinkedList<PersonalDataModifier>();
    private boolean innerCqn;
    private final boolean addPersonalData;
    private final PersonalDataCaches caches;
    private final Map<String, Pair<CdsStructuredType, List<CqnElementRef>>> sensitiveElements = new HashMap<String, Pair<CdsStructuredType, List<CqnElementRef>>>();

    PersonalDataModifier(CdsEntity target, boolean addPersonalData, PersonalDataCaches caches) {
        this(target, false, addPersonalData, caches);
    }

    private PersonalDataModifier(CdsEntity target, boolean innerCqn, boolean addPersonalData, PersonalDataCaches caches) {
        super(Objects.requireNonNull(target, "target must not null"));
        this.innerCqn = innerCqn;
        this.addPersonalData = addPersonalData;
        this.caches = Objects.requireNonNull(caches, "caches must not null");
    }

    public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
        this.innerCqn = true;
        return ref;
    }

    @Override
    protected TargetAwareCqnModifier create(CdsEntity target) {
        PersonalDataModifier result = new PersonalDataModifier(target, this.innerCqn, this.addPersonalData, this.caches);
        this.children.add(result);
        return result;
    }

    public List<CqnSelectListItem> selectAll() {
        this.getTarget().elements().filter(element -> element.getType().isSimple() || element.getType().isArrayed()).forEach(element -> this.addIfSensitive((CdsElement)element, (CqnElementRef)CQL.get((String)element.getName())));
        return super.selectAll();
    }

    public CqnValue ref(CqnElementRef ref) {
        CdsElement element;
        if (this.innerCqn && (element = CdsModelUtils.element((CdsStructuredType)this.getTarget(), (CqnElementRef)ref)) != null) {
            this.addIfSensitive(element, ref);
        }
        return ref;
    }

    private void addIfSensitive(CdsElement element, CqnElementRef ref) {
        if (CdsAnnotations.PERSONALDATA_POTENTIALLYSENSITIVE.isTrue((CdsAnnotatable)element) || CdsAnnotations.PERSONALDATA_POTENTIALLYPERSONAL.isTrue((CdsAnnotatable)element) && this.addPersonalData) {
            CdsStructuredType def = (CdsStructuredType)element.getDeclaringType();
            String key = def.getQualifiedName();
            if (this.sensitiveElements.containsKey(key)) {
                List elementList = (List)this.sensitiveElements.get(key).getRight();
                Optional<CqnElementRef> elementRefOpt = elementList.stream().filter(elementRef -> elementRef.lastSegment().equals(ref.lastSegment())).findFirst();
                if (!elementRefOpt.isPresent()) {
                    ((List)this.sensitiveElements.get(key).getRight()).add(ref);
                }
            } else {
                this.sensitiveElements.put(key, (Pair<CdsStructuredType, List<CqnElementRef>>)Pair.of((Object)def, new LinkedList<CqnElementRef>(Arrays.asList(ref))));
            }
        }
    }

    public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        if (this.innerCqn) {
            this.sensitiveElements.entrySet().forEach(entry -> {
                CqnElementRef ref = (CqnElementRef)((List)((Pair)entry.getValue()).getRight()).get(0);
                LinkedList<CqnReference.Segment> segments = new LinkedList<CqnReference.Segment>(ref.segments());
                segments.removeLast();
                PersonalDataMeta pdMeta = this.getMeta((CdsStructuredType)((Pair)entry.getValue()).getLeft());
                Set<CqnSelectListValue> elements = pdMeta.getKeyNames().stream().map(str -> CQL.get((String)str).as(PersonalDataUtils.getKeyAlias(str))).collect(Collectors.toSet());
                elements.addAll(this.getUtils((CdsStructuredType)((Pair)entry.getValue()).getLeft()).resolveDataSubjectId());
                if (segments.isEmpty()) {
                    elements.forEach(items::add);
                } else {
                    items.add((CqnSelectListItem)this.expandPath(segments, elements));
                }
            });
            this.innerCqn = false;
        }
        return super.items(items);
    }

    private Expand<?> expandPath(LinkedList<CqnReference.Segment> segments, Set<CqnSelectListValue> items) {
        if (segments.size() == 1) {
            return CQL.to(segments).expand((Selectable[])items.toArray(new CqnSelectListValue[0]));
        }
        CqnReference.Segment segment = segments.removeFirst();
        return CQL.to(Arrays.asList(segment)).expand(new Selectable[]{this.expandPath(segments, items)});
    }

    Map<String, Pair<CdsStructuredType, List<CqnElementRef>>> getSensitiveElements() {
        HashMap<String, Pair<CdsStructuredType, List<CqnElementRef>>> result = new HashMap<String, Pair<CdsStructuredType, List<CqnElementRef>>>(this.sensitiveElements);
        this.children.forEach(child -> {
            Map<String, Pair<CdsStructuredType, List<CqnElementRef>>> sensitiveElementsChild = child.getSensitiveElements();
            sensitiveElementsChild.entrySet().forEach(entry -> {
                if (result.containsKey(entry.getKey())) {
                    ((List)((Pair)result.get(entry.getKey())).getRight()).addAll((Collection)((Pair)entry.getValue()).getRight());
                } else {
                    result.put((String)entry.getKey(), (Pair<CdsStructuredType, List<CqnElementRef>>)entry.getValue());
                }
            });
        });
        return result;
    }

    private PersonalDataUtils getUtils(CdsStructuredType entity) {
        return this.caches.getUtils(entity);
    }

    private PersonalDataMeta getMeta(CdsStructuredType entity) {
        return this.caches.getMeta(entity);
    }
}

