/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.composite;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventPredicate;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.impl.composite.CompositeUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(CompositeService.class);
    private final String name;
    private final CdsRuntime runtime;
    private final Map<Pattern, Set<String>> eventMatcherToServices = new LinkedHashMap<Pattern, Set<String>>();

    public CompositeService(CdsProperties.Composite.CompositeServiceConfig config, CdsRuntime runtime) {
        this.name = config.getName();
        this.runtime = runtime;
        LinkedHashMap<String, Set> eventToServices = new LinkedHashMap<String, Set>();
        config.getRoutes().forEach(route -> route.getEvents().forEach(event -> {
            HashSet<String> services = (HashSet<String>)eventToServices.get(event);
            if (services == null) {
                services = new HashSet<String>();
                eventToServices.put((String)event, services);
            }
            if (StringUtils.isEmpty((String)route.getService())) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_DESTINATION_SERVICE, new Object[]{String.join((CharSequence)", ", route.getEvents()), this.getName()});
            }
            services.add(route.getService());
        }));
        eventToServices.forEach((event, services) -> this.eventMatcherToServices.put(CompositeUtils.getEventMatcherRegexp(event), (Set<String>)services));
        this.dump();
    }

    public String getName() {
        return this.name;
    }

    public void on(String[] events, String[] entities, int order, Handler handler) {
        for (String event : events) {
            Service destinationService = this.getDestinationService(event);
            logger.debug("Delegated the composite service '{}' ON handler registration for event '{}' to service '{}'", new Object[]{this.getName(), event, destinationService.getName()});
            destinationService.on(new String[]{event}, entities, order, handler);
        }
    }

    public void on(EventPredicate matcher, Handler handler) {
        throw new UnsupportedOperationException();
    }

    public void before(String[] events, String[] entities, int order, Handler handler) {
        for (String event : events) {
            Service destinationService = this.getDestinationService(event);
            logger.debug("Delegated the composite service '{}' BEFORE handler registration for event '{}' to service '{}'", new Object[]{this.getName(), event, destinationService.getName()});
            destinationService.before(new String[]{event}, entities, order, handler);
        }
    }

    public void before(EventPredicate matcher, Handler handler) {
        throw new UnsupportedOperationException();
    }

    public void after(String[] events, String[] entities, int order, Handler handler) {
        for (String event : events) {
            Service destinationService = this.getDestinationService(event);
            logger.debug("Delegated the composite service '{}' AFTER handler registration for event '{}' to service '{}'", new Object[]{this.getName(), event, destinationService.getName()});
            destinationService.after(new String[]{event}, entities, order, handler);
        }
    }

    public void after(EventPredicate matcher, Handler handler) {
        throw new UnsupportedOperationException();
    }

    public void emit(EventContext context) {
        Service destinationService = this.getDestinationService(context.getEvent());
        logger.debug("Emitting the event '{}' on service '{}'", (Object)context.getEvent(), (Object)destinationService.getName());
        destinationService.emit(context);
    }

    private Service getDestinationService(String event) {
        for (Map.Entry<Pattern, Set<String>> entry : this.eventMatcherToServices.entrySet()) {
            Iterator<String> iterator;
            if (!entry.getKey().matcher(event).matches() || !(iterator = entry.getValue().iterator()).hasNext()) continue;
            String service = iterator.next();
            Service srv = this.runtime.getServiceCatalog().getService(service);
            if (srv != null) {
                return srv;
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_SERVICE_IN_CATALOG, new Object[]{service, this.getName()});
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_DESTINATION_SERVICE, new Object[]{event, this.getName()});
    }

    private void dump() {
        logger.debug("");
        logger.debug("-------- Composite Service '{}' Routing Table --------", (Object)this.getName());
        logger.debug("");
        this.eventMatcherToServices.forEach((pattern, services) -> logger.debug("    {} -> {}", (Object)pattern.pattern(), (Object)Arrays.toString(services.toArray())));
        logger.debug("");
    }
}

