/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnSelectList;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.LeanModifier;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.draft.ReferenceModifier;
import com.sap.cds.services.impl.draft.SelectListModifier;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ColumnsModifier
implements LeanModifier {
    private final boolean forDraftEntity;
    private final CdsEntity target;
    private final EventContext context;

    public ColumnsModifier(CdsEntity target, EventContext context) {
        this.target = target;
        this.forDraftEntity = target.getQualifiedName().endsWith("_drafts");
        this.context = context;
    }

    public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        if (items.isEmpty() && (!this.forDraftEntity && DraftUtils.isDraftEnabled((CdsAnnotatable)this.target) || "DraftAdministrativeData".equals(this.target.getName()))) {
            items.add((CqnSelectListItem)CqnStar.star());
        }
        if (items.stream().anyMatch(i -> i.isStar())) {
            if (!this.forDraftEntity && DraftUtils.isDraftEnabled((CdsAnnotatable)this.target)) {
                items.add((CqnSelectListItem)this.element("IsActiveEntity"));
                items.add((CqnSelectListItem)this.element("HasDraftEntity"));
                items.add((CqnSelectListItem)this.element("HasActiveEntity"));
                items.add((CqnSelectListItem)this.element("DraftAdministrativeData_DraftUUID"));
            }
            if ("DraftAdministrativeData".equals(this.target.getName())) {
                items.add((CqnSelectListItem)this.element("InProcessByUser"));
                items.add((CqnSelectListItem)this.element("DraftIsCreatedByMe"));
            }
        }
        items = this.adaptItems(items);
        return super.items(items);
    }

    private CqnSelectListValue element(String field) {
        return CQL.get((String)field).withoutAlias();
    }

    public List<CqnValue> groupBy(List<CqnValue> groupBy) {
        List adapted = groupBy.stream().map(this::adaptValue).collect(Collectors.toList());
        return super.groupBy(adapted);
    }

    public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> orderBy) {
        ArrayList<CqnSortSpecification> specs = new ArrayList<CqnSortSpecification>(orderBy.size());
        for (CqnSortSpecification sortSpec : orderBy) {
            CqnValue val = this.adaptValue(sortSpec.value());
            specs.add(CQL.sort((CqnValue)val, (CqnSortSpecification.Order)sortSpec.order()));
        }
        return super.orderBy(specs);
    }

    private List<CqnSelectListItem> adaptItems(List<CqnSelectListItem> items) {
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            CqnSelectListItem item = items.get(i);
            if (item.isValue()) {
                items.set(i, this.adaptSLV(item.asValue()));
                continue;
            }
            if (!item.isSelectList()) continue;
            CqnSelectList selectList = item.asSelectList();
            if (DraftUtils.isDraftEnabled((CdsAnnotatable)this.target) && selectList.ref().stream().anyMatch(s -> "*".equals(s.id()))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_EXPAND_ALL_IN_DRAFT, new Object[0]);
            }
            List<List<Boolean>> followActiveAssociations = ReferenceModifier.getAssociationDirections(this.target, selectList.ref(), this.context, null);
            if (selectList.ref().size() > 1 && followActiveAssociations.size() > 1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_PATH_IN_DRAFT, new Object[0]);
            }
            items.remove(item);
            --i;
            --size;
            for (List<Boolean> followActive : followActiveAssociations) {
                CqnSelectList newSelectList = (CqnSelectList)ExpressionVisitor.copy((CqnSelectListItem)selectList, (Modifier)new SelectListModifier(this.target, followActive, this.context));
                items.add((CqnSelectListItem)newSelectList);
            }
        }
        return items;
    }

    private CqnSelectListItem adaptSLV(CqnSelectListValue slv) {
        CqnValue val = this.adaptValue(slv.value());
        return SelectListValueBuilder.select((CqnValue)val).as(slv.displayName()).build();
    }

    private CqnValue adaptValue(CqnValue val) {
        if (val.isRef()) {
            return this.adaptRef(val.asRef());
        }
        return val;
    }

    private CqnValue adaptRef(CqnElementRef ref) {
        RefBuilder copy = CQL.copy((CqnElementRef)ref);
        copy.segments().forEach(s -> {
            if ("SiblingEntity_unsecured".equals(s.id())) {
                s.id("SiblingEntity");
            }
        });
        DraftModifier modifier = new DraftModifier(this.target, false, false, this.context);
        return modifier.ref((CqnElementRef)copy.build());
    }
}

