/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.DraftUtils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class DraftGCTimerInitializer
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(DraftGCTimerInitializer.class);
    private final CdsRuntime runtime;
    private Timer timer;

    public DraftGCTimerInitializer(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    @On
    protected void initializeGC(ApplicationPreparedEventContext context) {
        if (this.runtime.getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled().booleanValue()) {
            return;
        }
        CdsProperties.Drafts.GC gcConfig = this.runtime.getEnvironment().getCdsProperties().getDrafts().getGc();
        if (gcConfig.isEnabled().booleanValue() && this.timer == null) {
            this.timer = new Timer("Draft GC Timer", true);
            long gcInterval = gcConfig.getInterval().toMillis();
            long firstExecutionTime = ThreadLocalRandom.current().nextLong(gcInterval);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DraftUtils.gcDraftsOfAllServicesAndTenants((CdsRuntime)DraftGCTimerInitializer.this.runtime);
                    }
                    catch (Throwable t) {
                        log.error("Failed to gc drafts", t);
                    }
                }
            }, firstExecutionTime, gcInterval);
        }
    }

    @On
    protected void stopGC(ApplicationStoppedEventContext context) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

