/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.mt.DependenciesEventContext;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.SubscribeEventContext;
import com.sap.cds.services.mt.UnsubscribeEventContext;
import com.sap.cds.services.mt.UpgradeEventContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentServiceImpl
extends ServiceDelegator
implements DeploymentService {
    public DeploymentServiceImpl(String name) {
        super(name);
    }

    public List<Map<String, Object>> dependencies() {
        DependenciesEventContext context = DependenciesEventContext.create();
        this.emit((EventContext)context);
        return context.getResult();
    }

    public void subscribe(String tenant, Map<String, Object> options) {
        SubscribeEventContext context = SubscribeEventContext.create();
        context.setTenant(tenant);
        context.setOptions((Map)(options == null ? new HashMap() : options));
        this.emit((EventContext)context);
    }

    public void upgrade(List<String> tenants, Map<String, Object> options) {
        UpgradeEventContext context = UpgradeEventContext.create();
        context.setTenants((List)(tenants == null ? new ArrayList() : tenants));
        context.setOptions((Map)(options == null ? new HashMap() : options));
        this.emit((EventContext)context);
    }

    public void unsubscribe(String tenant, Map<String, Object> options) {
        UnsubscribeEventContext context = UnsubscribeEventContext.create();
        context.setTenant(tenant);
        context.setOptions((Map)(options == null ? new HashMap() : options));
        this.emit((EventContext)context);
    }

    @On
    @HandlerOrder(value=11000)
    private void defaultDependencies(DependenciesEventContext context) {
        context.setResult(new ArrayList());
    }

    @On(event={"SUBSCRIBE", "UPGRADE", "UNSUBSCRIBE"})
    @HandlerOrder(value=0x7FFFFFFE)
    private void autoComplete(EventContext context) {
        context.setCompleted();
    }
}

