/**************************************************************************
 * (C) 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.draft;

import java.util.ArrayList;
import java.util.List;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.LeanModifier;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.model.CdsModelUtils;

/**
 * A {@link Modifier} for expand and inline parts of the statement
 */
public class SelectListModifier implements LeanModifier {

	private final CdsEntity target;
	private final List<Boolean> followActiveAssociations;
	private final EventContext context;

	public SelectListModifier(CdsEntity target, List<Boolean> followActiveAssociations, EventContext context) {
		this.target = target;
		this.followActiveAssociations = followActiveAssociations; // NOSONAR
		this.context = context;
	}

	@Override
	public CqnSelectListItem expand(CqnExpand expand) {
		CqnStructuredTypeRef newRef = ExpressionVisitor.copy(expand.ref(), new ReferenceModifier(target, followActiveAssociations, true, context));
		Modifier columnModifier = new ColumnsModifier(CdsModelUtils.getRefTarget(newRef, target), context);
		return CQL.to(newRef.segments()).as(expand.alias().orElse(null))
				.expand(columnModifier.items(new ArrayList<>(expand.items())))
				.orderBy(columnModifier.orderBy(new ArrayList<>(expand.orderBy())))
				.limit(expand.top(), expand.skip());
	}

	@Override
	public CqnSelectListItem inline(CqnInline inline) {
		CqnStructuredTypeRef newRef = ExpressionVisitor.copy(inline.ref(), new ReferenceModifier(target, followActiveAssociations, true, context));
		Modifier columnModifier = new ColumnsModifier(CdsModelUtils.getRefTarget(newRef, target), context);
		List<CqnSelectListItem> items = new ArrayList<>(inline.items());
		return CQL.to(newRef.segments()).inline(columnModifier.items(items));
	}

}
