/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.environment;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.environment.VcapServicesParser;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;

public class DefaultServiceBindingProvider implements ServiceBindingProvider {

	private final CdsRuntime runtime;
	private List<ServiceBinding> bindings;

	public DefaultServiceBindingProvider(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Stream<ServiceBinding> get() {
		if(bindings == null) {
			bindings = loadBindings();
		}
		return bindings.stream();
	}

	private List<ServiceBinding> loadBindings() {
		List<ServiceBinding> bindings = DefaultServiceBindingAccessor.getInstance().getServiceBindings().stream().map(ServiceBindingAdapter::new).collect(Collectors.toList());
		// default-env.json is only used, when no other bindings are available
		if(bindings.isEmpty()) {
			// TODO make service bindings from default-env.json available to other libraries as well
			return VcapServicesParser.getServiceBindings(DefaultEnvFileUtils.getDefaultEnv(runtime));
		}
		return bindings;
	}

}
