/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestParameters;
import com.sap.cds.services.utils.CorrelationIdUtils;
import com.sap.cds.services.utils.HttpHeaders;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.QueryParameters;
import com.sap.cds.services.utils.TemporalRangeUtils;

@Deprecated
public class ParameterInfoImpl implements ParameterInfo {

	private final RequestParameters requestParameter;
	private final LocaleUtils localeUtils;

	private Locale locale;

	private Instant validFrom;

	private Instant validTo;

	private String correlationId;

	public ParameterInfoImpl(RequestParameters requestParameter, CdsRuntime runtime) {
		this.requestParameter = requestParameter;
		this.localeUtils = new LocaleUtils(runtime.getEnvironment().getCdsProperties());
	}

	@Override
	public String getCorrelationId() {
		if (correlationId == null) {
			correlationId = CorrelationIdUtils.getOrGenerateCorrelationId(this);
		}
		return correlationId;
	}

	@Override
	public String getHeader(String id) {
		return requestParameter.getHeader(id);
	}

	@Override
	public String getQueryParameter(String key) {
		return requestParameter.getQueryParameter(key);
	}

	@Override
	public Stream<String> getQueryParameters() {
		return requestParameter.getQueryParameters();
	}

	@Override
	public Map<String, String> getHeaders() {
		throw new UnsupportedOperationException("RequestParameters is deprecated and does not support getHeaders()");
	}

	@Override
	public Map<String, String> getQueryParams() {
		Map<String, String> result = new TreeMap<>();
		getQueryParameters().forEach(q -> result.put(q, getQueryParameter(q)));
		return result;
	}

	@Override
	public Locale getLocale() {
		if (locale == null) {
			locale = localeUtils.getLocale(
					getQueryParameter(QueryParameters.SAP_LOCALE),
					getHeader(HttpHeaders.ACCEPT_LANGUAGE),
					getQueryParameter(QueryParameters.SAP_LANGUAGE),
					getHeader(HttpHeaders.X_SAP_REQUEST_LANGUAGE_HEADER));
		}
		return locale;
	}

	@Override
	public Instant getValidFrom() {
		if (this.validFrom == null) {
			setTemporalRange();
		}
		return this.validFrom;
	}

	@Override
	public Instant getValidTo() {
		if (this.validTo == null) {
			setTemporalRange();
		}
		return this.validTo;
	}

	private void setTemporalRange() {
		Instant[] range = TemporalRangeUtils.getTemporalRanges(
			getQueryParameter(QueryParameters.VALID_FROM),
			getQueryParameter(QueryParameters.VALID_TO),
			getQueryParameter(QueryParameters.VALID_AT)
		);

		this.validFrom = range[0];
		this.validTo = range[1];
	}
}
