/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import java.util.Objects;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class RequestContextHelper implements RequestContext {

	private final CdsRuntime runtime;

	RequestContextHelper(CdsRuntime runtime) {
		Objects.requireNonNull(runtime, "runtime must not be null");
		this.runtime = runtime;
	}

	@Override
	public CdsModel getModel() {
		UserInfo providedUserInfo = runtime.getProvidedUserInfo();
		return runtime.getCdsModel(providedUserInfo, runtime.getFeatureTogglesInfo(providedUserInfo, runtime.getProvidedParameterInfo()));
	}

	@Override
	public ServiceCatalog getServiceCatalog() {
		return runtime.getServiceCatalog();
	}

	@Override
	public ParameterInfo getParameterInfo() {
		return runtime.getProvidedParameterInfo();
	}

	@Override
	public UserInfo getUserInfo() {
		return runtime.getProvidedUserInfo();
	}

	@Override
	public AuthenticationInfo getAuthenticationInfo() {
		return runtime.getProvidedAuthenticationInfo();
	}

	@Override
	public Messages getMessages() {
		throw new ErrorStatusException(CdsErrorStatuses.TEMPORARY_REQUEST_CONTEXT_MESSAGES);
	}

	@Override
	public FeatureTogglesInfo getFeatureTogglesInfo() {
		return runtime.getFeatureTogglesInfo(runtime.getProvidedUserInfo(), runtime.getProvidedParameterInfo());
	}

}
