/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.RequestUser;
import com.sap.cds.services.utils.ClassMethods;

@Deprecated
public class UserInfoImpl implements UserInfo {

	private final RequestUser requestUser;

	private static final String SPECIAL_ATTRIBUTE_TENANT = "tenant";

	private static final String EXTENSION_ATTRIBUTES = "ext_attr";

	private static final String SERVICEINSTANCEID_ATTRIBUTE = "serviceinstanceid";

	private static final String SPECIAL_ATTRIBUTE_SERVICEINSTANCEID = EXTENSION_ATTRIBUTES + "."
			+ SERVICEINSTANCEID_ATTRIBUTE;

	public UserInfoImpl(RequestUser requestUser) {
		this.requestUser = requestUser;
	}

	@Override
	public String getId() {
		return requestUser.getId();
	}

	@Override
	public String getName() {
		return requestUser.getName();
	}

	@Override
	public String getTenant() {
		return requestUser.getTenant();
	}

	@Override
	public boolean isSystemUser() {
		return requestUser.isSystemUser();
	}

	@Override
	public boolean hasRole(String role) {
		return requestUser.getRoles().contains(role);
	}

	@Override
	public Stream<String> getAttribute(String attribute) {
		if (requestUser.getUserAttribute(attribute) != null) {
			return requestUser.getUserAttribute(attribute).stream();
		}

		// handle some special attributes
		if (attribute.equals(SPECIAL_ATTRIBUTE_TENANT)) {
			return Stream.of(requestUser.getTenant());

		} else if (attribute.equals(SPECIAL_ATTRIBUTE_SERVICEINSTANCEID)) {

			Object serviceInstanceId = requestUser.getExtensionAttribute(SERVICEINSTANCEID_ATTRIBUTE);
			if (serviceInstanceId != null && serviceInstanceId instanceof String) {
				return Stream.of((String) serviceInstanceId);
			}
		}

		return Stream.empty();
	}

	@Override
	public List<String> getAttributeValues(String attribute) {
		return getAttribute(attribute).collect(Collectors.toList());
	}

	@Override
	public boolean isUnrestrictedAttribute(String attribute) {
		return requestUser.isUnrestrictedUserAttribute(attribute);
	}

	@Override
	public boolean isAuthenticated() {
		// when we reach here, the user has been authenticated by the framework
		// (special empty user is set otherwise)
		return true;
	}

	@Override
	public Set<String> getRoles() {
		return new TreeSet<>(requestUser.getRoles());
	}

	@Override
	public Map<String, List<String>> getAttributes() {
		throw new UnsupportedOperationException("RequestUser is deprecated and does not allow this operation");
	}

	@Override
	public Set<String> getUnrestrictedAttributes() {
		throw new UnsupportedOperationException("RequestUser is deprecated and does not allow this operation");
	}

	@Override
	public Map<String, Object> getAdditionalAttributes() {
		return requestUser.getAdditionalAttributes();
	}

	@Override
	public Object getAdditionalAttribute(String name) {
		return requestUser.getAdditionalAttributes().get(name);
	}

	@Override
	public <T extends UserInfo> T as(Class<T> userInfoClazz) {
		return ClassMethods.as(userInfoClazz, UserInfo.class, this, this::getAdditionalAttributes);
	}

}
