/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.auditlog.Action;
import com.sap.cds.services.auditlog.ConfigChangeLog;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.auditlog.DataAccessLog;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.auditlog.DataModificationLog;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.auditlog.SecurityLog;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@ServiceName(value={"*"}, type={OutboxService.class})
public class AuditLogDefaultOutboxOnHandler
implements EventHandler {
    public static final String OUTBOX_AUDITLOG_TARGET = "auditlog/AuditlogService$Default";
    private static final JsonMapper mapper = new JsonMapper();
    private static final String USER = "user";
    private static final String TENANT = "tenant";
    private static final String LOGON_NAME = "logonName";
    private static final String IS_AUTHENTICATED = "isAuthenticated";
    private static final String IS_SYSTEM_USER = "isSystemUser";
    private static final String EVENT = "event";
    private static final String DATA = "data";
    private static final String CREATED_AT = "createdAt";
    private static final String ACTION = "action";
    private static final String MODIFICATIONS = "modifications";
    private CdsModel auditlogModel;

    public AuditLogDefaultOutboxOnHandler() {
        String csnPath = "auditlog.csn";
        try (InputStream is = AuditLogDefaultOutboxOnHandler.class.getClassLoader().getResourceAsStream(csnPath);){
            if (is == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_AUDITLOG_MODEL, new Object[]{csnPath});
            }
            this.auditlogModel = CdsModelReader.read((InputStream)is);
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.AUDITLOG_NOT_READABLE, new Object[]{csnPath, e});
        }
    }

    @On(event={"auditlog/AuditlogService$Default"})
    private void publishedByOutbox(OutboxMessageEventContext context) {
        Service auditlogService = context.getServiceCatalog().getService("AuditlogService$Default");
        if (auditlogService != null) {
            EventContextAccessor contextAccessor = new EventContextAccessor(context, this.auditlogModel);
            context.getCdsRuntime().requestContext().modifyUser(u -> {
                u.setName(contextAccessor.getUser());
                u.setIsAuthenticated(contextAccessor.isAuhenticated());
                u.setIsSystemUser(contextAccessor.isSystemUser());
                u.setTenant(contextAccessor.getTenant());
                u.setAdditionalAttribute(LOGON_NAME, (Object)contextAccessor.getLogonName());
            }).run(req -> auditlogService.emit(contextAccessor.getContext()));
        }
    }

    static String createOutboxMessage(EventContext context, CdsRuntime runtime) {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)runtime);
        try {
            CdsData data = (CdsData)context.get(DATA);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(USER, requestContext.getUserInfo().getName());
            map.put(TENANT, requestContext.getUserInfo().getTenant());
            map.put(IS_AUTHENTICATED, requestContext.getUserInfo().isAuthenticated());
            map.put(IS_SYSTEM_USER, requestContext.getUserInfo().isSystemUser());
            String logonName = (String)requestContext.getUserInfo().getAdditionalAttribute(LOGON_NAME);
            if (!StringUtils.isEmpty((String)logonName)) {
                map.put(LOGON_NAME, logonName);
            }
            map.put(EVENT, context.getEvent());
            map.put(DATA, data.toJson());
            return mapper.writeValueAsString(map);
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONTEXT_SERIALIZATION_FAILED, new Object[]{context.getEvent(), e});
        }
    }

    private static class EventContextAccessor {
        private String user;
        private String tenant;
        private String logonName;
        private boolean isAuhenticated;
        private boolean isSystemUser;
        private EventContext context;

        private EventContextAccessor(OutboxMessageEventContext outboxContext, CdsModel auditlogModel) {
            try {
                Map contextData = (Map)mapper.readValue(outboxContext.getMessage(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                this.user = (String)contextData.get(AuditLogDefaultOutboxOnHandler.USER);
                this.tenant = (String)contextData.get(AuditLogDefaultOutboxOnHandler.TENANT);
                this.logonName = (String)contextData.get(AuditLogDefaultOutboxOnHandler.LOGON_NAME);
                this.isAuhenticated = Boolean.TRUE.equals(contextData.get(AuditLogDefaultOutboxOnHandler.IS_AUTHENTICATED));
                this.isSystemUser = Boolean.TRUE.equals(contextData.get(AuditLogDefaultOutboxOnHandler.IS_SYSTEM_USER));
                String event = (String)contextData.get(AuditLogDefaultOutboxOnHandler.EVENT);
                this.context = EventContext.create((String)event, null);
                CdsEvent type = auditlogModel.getEvent("com.sap.cds.services.auditlog." + event);
                Map data = StructDataParser.create((CdsStructuredType)type).parseObject((String)contextData.get(AuditLogDefaultOutboxOnHandler.DATA));
                this.adaptActionType(data, event);
                this.setData(this.context, event, data);
                this.context.put(AuditLogDefaultOutboxOnHandler.CREATED_AT, (Object)outboxContext.getTimestamp());
                this.context.put("IS_OUTBOXED", (Object)true);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONTEXT_DESERIALIZATION_FAILED, new Object[]{outboxContext.getEvent(), e});
            }
        }

        private void setData(EventContext context, String event, Map<String, Object> data) {
            if (event.equals("dataModificationLog")) {
                DataModificationLog log = (DataModificationLog)Struct.access(data).as(DataModificationLog.class);
                ((DataModificationLogContext)context.as(DataModificationLogContext.class)).setData(log);
            } else if (event.equals("configChangeLog")) {
                ConfigChangeLog log = (ConfigChangeLog)Struct.access(data).as(ConfigChangeLog.class);
                ((ConfigChangeLogContext)context.as(ConfigChangeLogContext.class)).setData(log);
            } else if (event.equals("securityLog")) {
                SecurityLog log = (SecurityLog)Struct.access(data).as(SecurityLog.class);
                ((SecurityLogContext)context.as(SecurityLogContext.class)).setData(log);
            } else if (event.equals("dataAccessLog")) {
                DataAccessLog log = (DataAccessLog)Struct.access(data).as(DataAccessLog.class);
                ((DataAccessLogContext)context.as(DataAccessLogContext.class)).setData(log);
            }
        }

        private void adaptActionType(Map<String, Object> data, String event) {
            Object action;
            if (event.equals("dataModificationLog")) {
                Collection modifications = (Collection)data.get(AuditLogDefaultOutboxOnHandler.MODIFICATIONS);
                if (modifications != null) {
                    modifications.forEach(modification -> {
                        Object action = modification.get(AuditLogDefaultOutboxOnHandler.ACTION);
                        if (action != null) {
                            modification.put(AuditLogDefaultOutboxOnHandler.ACTION, Action.valueOf((String)action.toString()));
                        }
                    });
                }
            } else if (event.equals("configChangeLog") && (action = data.get(AuditLogDefaultOutboxOnHandler.ACTION)) != null) {
                data.put(AuditLogDefaultOutboxOnHandler.ACTION, Action.valueOf((String)action.toString()));
            }
        }

        public String getUser() {
            return this.user;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getLogonName() {
            return this.logonName;
        }

        public boolean isAuhenticated() {
            return this.isAuhenticated;
        }

        public boolean isSystemUser() {
            return this.isSystemUser;
        }

        public EventContext getContext() {
            return this.context;
        }
    }
}

