/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.auditlog.Action;
import com.sap.cds.services.auditlog.ChangedAttribute;
import com.sap.cds.services.auditlog.DataModification;
import com.sap.cds.services.impl.auditlog.PersonalDataAnalyzer;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

class PersonalDataAnalyzerModification
extends PersonalDataAnalyzer {
    private List<? extends Map<String, Object>> oldData;

    PersonalDataAnalyzerModification(CdsStructuredType entity, PersonalDataCaches caches, CdsRuntime runtime) {
        super(entity, caches, runtime);
    }

    PersonalDataAnalyzerModification(CdsEntity entity, List<? extends Map<String, Object>> data, PersonalDataCaches caches, CdsRuntime runtime) {
        this((CdsStructuredType)entity, caches, runtime);
        this.setData(data);
    }

    public void setOldData(List<? extends CdsData> oldData) {
        this.oldData = oldData;
    }

    public List<DataModification> getDataModifications() {
        if (this.oldData != null) {
            if (this.data == null) {
                return this.getDeleteDataModifications(this.entity, this.oldData);
            }
            return this.getUpdateDataModifications(this.entity, this.oldData, this.data);
        }
        if (this.data != null) {
            return this.getCreateDataModification(this.entity, this.data);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasPersonalData() {
        if (this.data != null) {
            return this.hasPersonalData(this.entity, this.data);
        }
        return this.getMeta(this.entity).hasPersonalData();
    }

    private boolean hasPersonalData(CdsStructuredType entity, Iterable<? extends Map<String, Object>> data) {
        final AtomicBoolean hasPersonalData = new AtomicBoolean(false);
        DataProcessor.create().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> dataList) {
                PersonalDataMeta meta = PersonalDataAnalyzerModification.this.getMeta(type);
                if (meta != null) {
                    Set<String> personal = meta.getPersonalDataNames();
                    if (!hasPersonalData.get() && meta.hasPersonalData() && StreamSupport.stream(dataList.spliterator(), false).anyMatch(dataRow -> dataRow.keySet().stream().anyMatch(personal::contains))) {
                        hasPersonalData.set(true);
                    }
                }
            }
        }).process(data, entity);
        return hasPersonalData.get();
    }

    private List<DataModification> getCreateDataModification(CdsStructuredType entity, List<? extends Map<String, Object>> data) {
        final ArrayList<DataModification> modifications = new ArrayList<DataModification>();
        DataProcessor.create().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType currentEntity, Iterable<Map<String, Object>> dataList) {
                PersonalDataMeta meta = PersonalDataAnalyzerModification.this.getMeta(currentEntity);
                if (meta != null && meta.isAuditInsert()) {
                    for (Map<String, Object> dataRow : dataList) {
                        List attributes = PersonalDataAnalyzerModification.createChangedAttributes(null, dataRow, meta);
                        if (attributes.isEmpty()) continue;
                        DataModification modification = DataModification.create();
                        modification.setAction(Action.CREATE);
                        modification.setDataObject(PersonalDataAnalyzerModification.this.createDataObject(dataRow, meta));
                        modification.setAttributes((Collection)attributes);
                        modification.setDataSubject(PersonalDataAnalyzerModification.this.createDataSubject(dataRow, meta));
                        modifications.add(modification);
                    }
                }
            }
        }).process(data, entity);
        return modifications;
    }

    private List<DataModification> getUpdateDataModifications(CdsStructuredType currentEntity, Iterable<? extends Map<String, Object>> oldData, Iterable<? extends Map<String, Object>> newData) {
        ArrayList<DataModification> modifications = new ArrayList<DataModification>();
        PersonalDataMeta meta = this.getMeta(currentEntity);
        HashMap keyMappedNewData = new HashMap();
        newData.forEach(newDataRow -> {
            String keyValues = PersonalDataAnalyzerModification.createKeyValues(meta.getKeyNames(), newDataRow);
            keyMappedNewData.put(keyValues, newDataRow);
        });
        oldData.forEach(oldDataRow -> {
            String keyValues = PersonalDataAnalyzerModification.createKeyValues(meta.getKeyNames(), oldDataRow);
            Map newDataRow = (Map)keyMappedNewData.remove(keyValues);
            if (newDataRow != null) {
                List<ChangedAttribute> attributes;
                if (meta.isAuditUpdate() && !(attributes = PersonalDataAnalyzerModification.createChangedAttributes(oldDataRow, newDataRow, meta)).isEmpty()) {
                    DataModification modification = DataModification.create();
                    modification.setAction(Action.UPDATE);
                    modification.setDataObject(this.createDataObject((Map<String, Object>)oldDataRow, meta));
                    modification.setDataSubject(this.createDataSubject((Map<String, Object>)oldDataRow, meta));
                    modification.setAttributes(attributes);
                    modifications.add(modification);
                }
                currentEntity.associations().forEach(assoc -> {
                    if (oldDataRow.containsKey(assoc.getName())) {
                        Object oldDataAssoc = oldDataRow.get(assoc.getName());
                        Object newDataAssoc = newDataRow.get(assoc.getName());
                        if (oldDataAssoc instanceof Iterable) {
                            modifications.addAll(this.getUpdateDataModifications(currentEntity.getTargetOf(assoc.getName()), (Iterable)oldDataAssoc, (Iterable)newDataAssoc));
                        } else if (oldDataAssoc instanceof Map) {
                            modifications.addAll(this.getUpdateDataModifications(currentEntity.getTargetOf(assoc.getName()), Arrays.asList((Map)oldDataAssoc), Arrays.asList((Map)newDataAssoc)));
                        }
                    }
                });
            } else {
                modifications.addAll(this.getDeleteDataModifications(currentEntity, Arrays.asList(oldDataRow)));
            }
        });
        keyMappedNewData.values().forEach(dataRow -> modifications.addAll(this.getCreateDataModification(currentEntity, Arrays.asList(dataRow))));
        return modifications;
    }

    private List<DataModification> getDeleteDataModifications(CdsStructuredType entity, List<? extends Map<String, Object>> data) {
        final ArrayList<DataModification> modifications = new ArrayList<DataModification>();
        DataProcessor.create().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType currentEntity, Iterable<Map<String, Object>> dataList) {
                PersonalDataMeta meta = PersonalDataAnalyzerModification.this.getMeta(currentEntity);
                if (meta != null && meta.isAuditDelete()) {
                    for (Map<String, Object> dataRow : dataList) {
                        List attributes = PersonalDataAnalyzerModification.createDeletedAttributes(dataRow, meta);
                        if (attributes.isEmpty()) continue;
                        DataModification modification = DataModification.create();
                        modification.setAction(Action.DELETE);
                        modification.setDataObject(PersonalDataAnalyzerModification.this.createDataObject(dataRow, meta));
                        modification.setDataSubject(PersonalDataAnalyzerModification.this.createDataSubject(dataRow, meta));
                        modification.setAttributes((Collection)attributes);
                        modifications.add(modification);
                    }
                }
            }
        }).process(data, entity);
        return modifications;
    }

    private static List<ChangedAttribute> createChangedAttributes(Map<String, Object> oldData, Map<String, Object> newData, PersonalDataMeta meta) {
        ArrayList<ChangedAttribute> attributes = new ArrayList<ChangedAttribute>();
        meta.getPersonalDataNames().forEach(pdName -> {
            ChangedAttribute attribute = ChangedAttribute.create();
            attribute.setName(pdName);
            Object newValue = newData.getOrDefault(pdName, null);
            if (newValue != null) {
                Object oldValue;
                attribute.setNewValue(newValue.toString());
                if (oldData != null && (oldValue = oldData.getOrDefault(pdName, null)) != null) {
                    attribute.setOldValue(oldData.get(pdName).toString());
                }
            }
            if (!StringUtils.equals((CharSequence)attribute.getNewValue(), (CharSequence)attribute.getOldValue())) {
                attributes.add(attribute);
            }
        });
        return attributes;
    }

    private static List<ChangedAttribute> createDeletedAttributes(Map<String, Object> dataRow, PersonalDataMeta meta) {
        ArrayList<ChangedAttribute> attributes = new ArrayList<ChangedAttribute>();
        meta.getPersonalDataNames().forEach(pdName -> {
            Object oldValue;
            ChangedAttribute attribute = ChangedAttribute.create();
            attribute.setName(pdName);
            attribute.setNewValue(null);
            if (dataRow != null && (oldValue = dataRow.getOrDefault(pdName, null)) != null) {
                attribute.setOldValue(dataRow.get(pdName).toString());
            }
            if (!StringUtils.equals((CharSequence)attribute.getNewValue(), (CharSequence)attribute.getOldValue())) {
                attributes.add(attribute);
            }
        });
        return attributes;
    }

    private static String createKeyValues(List<String> keyNames, Map<String, Object> dataRow) {
        StringBuilder keyBuilder = new StringBuilder();
        keyNames.stream().forEach(keyName -> keyBuilder.append(dataRow.get(keyName)));
        return keyBuilder.toString();
    }
}

