package com.sap.cds.services.impl.auditlog;

import java.time.Instant;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.DataModificationLog;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.impl.EventContextDelegator;

public class DataModificationLogContextImpl extends EventContextDelegator implements DataModificationLogContext {
	private static final String PARAM_DATA = "data";
	private static final String PARAM_CREATED_AT = "createdAt";

	public DataModificationLogContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public AuditLogService getService() {
		return (AuditLogService) super.getService();
	}

	public DataModificationLog getData() {
		return (DataModificationLog)get(PARAM_DATA);
	}

	public void setData(DataModificationLog event) {
		put(PARAM_DATA, event);
	}

	public Instant getCreatedAt() {
		return (Instant) get(PARAM_CREATED_AT);
	}

	public void setCreatedAt(Instant createdAt) {
		put(PARAM_CREATED_AT, createdAt);
	}
}
