package com.sap.cds.services.impl.draft;

import java.util.Collections;
import java.util.stream.StreamSupport;

import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.services.EventContext;

public class DraftHandlerUtils {

	public static Result buildNoOpResult(EventContext context) {
		CqnStatement statement = (CqnStatement) context.get("cqn");
		if (statement.isUpdate() || statement.isDelete()) {
			int batches = (int) StreamSupport.stream(((Iterable<?>) context.get("cqnValueSets")).spliterator(), false).count();
			return ResultBuilder.deletedRows(new long[batches]).rowType(context.getTarget()).result();
		}
		return ResultBuilder.selectedRows(Collections.emptyList()).rowType(context.getTarget()).result();
	}

}
