/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.draft;

import java.util.Map;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftPrepareEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;

/**
 * Implementation of the {@link EventContext} for the {@link DraftService#EVENT_DRAFT_PREPARE} event.
 */
public class DraftPrepareEventContextImpl extends EventContextDelegator implements DraftPrepareEventContext {

	public DraftPrepareEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public DraftService getService() {
		return (DraftService)super.getService();
	}

	private static final String PARAM_CQN = "cqn";
	private static final String PARAM_SIDE_EFFECTS_QUALIFIER = "SideEffectsQualifier";
	private static final String PARAM_CQN_NAMED_VALUES = "cqnNamedValues";
	private static final String PARAM_RESULT = "result";

	// IN
	/**
	 * @return the {@link CqnSelect} statement
	 */
	public CqnSelect getCqn() {
		return (CqnSelect)get(PARAM_CQN);
	}

	/**
	 * Sets the {@link CqnSelect} statement
	 * @param cqn the {@link CqnSelect} statement
	 */
	public void setCqn(CqnSelect cqn) {
		put(PARAM_CQN, cqn);
	}

	/**
	 * Sets the sideEffectQualifier
	 * @param sideEffectsQualifier the side effects qualifier
	 */
	public void setSideEffectsQualifier(String sideEffectsQualifier) {
		put(PARAM_SIDE_EFFECTS_QUALIFIER, sideEffectsQualifier);
	}

	/**
	 * @return the side effects qualifier
	 */
	public String getSideEffectsQualifier() {
		return (String)get(PARAM_SIDE_EFFECTS_QUALIFIER);
	}

	/**
	 * The CQN named values, for parameterized {@link CqnSelect} statements
	 * @return the CQN named values
	 */
	@SuppressWarnings("unchecked")
	public Map<String, Object> getCqnNamedValues() {
		return (Map<String, Object>)get(PARAM_CQN_NAMED_VALUES);
	}

	/**
	 * Sets the CQN named values, for parameterized {@link CqnSelect} statements
	 * @param namedValues the CQN named values
	 */
	public void setCqnNamedValues(Map<String, Object> namedValues) {
		put(PARAM_CQN_NAMED_VALUES, namedValues);
	}

	// OUT
	/**
	 * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_PREPARE} event
	 */
	public Result getResult() {
		return (Result)get(PARAM_RESULT);
	}

	/**
	 * Sets the result of the {@link DraftService#EVENT_DRAFT_PREPARE} event
	 * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link Result}
	 */
	public void setResult(Iterable<? extends Map<String, ?>> result) {
		put(PARAM_RESULT, ResultUtils.convert(result));
		setCompleted();
	}

}
