/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import com.sap.cds.services.request.ModifiableParameterInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.utils.CorrelationIdUtils;

public class ParameterInfoFactory {

	public static ModifiableParameterInfo create(ParameterInfo parameterInfo) {
		return new ModifiableParameterInfoImpl(parameterInfo != null ? parameterInfo : emptyParameterInfo());
	}

	public static ParameterInfo emptyParameterInfo() {
		return new ParameterInfo() {

			// required to be able to pass the value from one thread to another
			private String correlationId;

			@Override
			public String getCorrelationId() {
				if (correlationId == null) {
					correlationId = CorrelationIdUtils.getOrGenerateCorrelationId(this);
				}
				return correlationId;
			}
		};
	}

}
