/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.draft.DraftGcEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.DraftUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class DraftGCHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(DraftGCHandler.class);
    private final CdsRuntime runtime;
    private Timer timer;

    public DraftGCHandler(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    @On
    protected void initializeGC(ApplicationPreparedEventContext context) {
        if (this.runtime.getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled().booleanValue()) {
            return;
        }
        CdsProperties.Drafts.GC gcConfig = this.runtime.getEnvironment().getCdsProperties().getDrafts().getGc();
        if (gcConfig.isEnabled().booleanValue() && this.timer == null) {
            this.timer = new Timer("Draft GC Timer", true);
            long gcInterval = gcConfig.getInterval().toMillis();
            long firstExecutionTime = ThreadLocalRandom.current().nextLong(gcInterval);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DraftUtils.gcDraftsOfAllServicesAndTenants((CdsRuntime)DraftGCHandler.this.runtime);
                    }
                    catch (Throwable t) {
                        log.error("Failed to gc drafts", t);
                    }
                }
            }, firstExecutionTime, gcInterval);
        }
    }

    @On(service={"*"}, serviceType={DraftService.class})
    @HandlerOrder(value=11000)
    protected void onGcDrafts(DraftGcEventContext context) {
        AtomicLong numCancelledDrafts = new AtomicLong(0L);
        Instant threshold = Instant.now().minus(context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().getDeletionTimeout()).truncatedTo(ChronoUnit.MILLIS);
        DraftService draftService = context.getService();
        draftService.getDefinition().entities().forEach(e -> {
            if (DraftUtils.isDraftRoot((CdsAnnotatable)e) && !e.getQualifiedName().endsWith("_drafts")) {
                Delete deleteOldDrafts = Delete.from((CdsEntity)e).where(c -> c.get("IsActiveEntity").eq((Object)false).and((CqnPredicate)c.exists(outer -> Select.from((String)"DRAFT.DraftAdministrativeData").where(a -> a.get("DraftUUID").eq((Value)outer.get("DraftAdministrativeData_DraftUUID")).and((CqnPredicate)a.get("LastChangeDateTime").le((Object)threshold), new CqnPredicate[0]))), new CqnPredicate[0]));
                Result result = (Result)context.getCdsRuntime().requestContext().privilegedUser().run(arg_0 -> DraftGCHandler.lambda$onGcDrafts$3(draftService, (CqnDelete)deleteOldDrafts, arg_0));
                if (result.rowCount() > 0L) {
                    log.info("Draft GC deleted {} drafts of entity '{}'", (Object)result.rowCount(), (Object)e.getQualifiedName());
                    numCancelledDrafts.addAndGet(result.rowCount());
                }
            }
        });
        context.setResult(ResultBuilder.deletedRows((long)numCancelledDrafts.get()).result());
    }

    @On
    protected void stopGC(ApplicationStoppedEventContext context) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private static /* synthetic */ Result lambda$onGcDrafts$3(DraftService draftService, CqnDelete deleteOldDrafts, RequestContext requestContext) {
        return draftService.cancelDraft(deleteOldDrafts, new Object[0]);
    }
}

