/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.model;

import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicModelProvider
implements CdsModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(DynamicModelProvider.class);
    private final CdsRuntime runtime;
    private final DynamicModelUtils utils;
    private final MetaDataAccessor<String> accessor;

    public DynamicModelProvider(CdsRuntime runtime) {
        this.runtime = runtime;
        this.utils = new DynamicModelUtils(runtime);
        this.accessor = this.utils.createMetadataAccessor(null, csn -> CdsModelReader.read((CdsModelReader.Config)CdsModelUtils.buildCdsModelReaderConfig(runtime), (String)csn, (boolean)true));
    }

    public CdsModel get(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        if (this.utils.useStaticModel(userInfo, featureTogglesInfo)) {
            return this.runtime.getCdsModel();
        }
        String tenant = userInfo.getTenant();
        if (logger.isDebugEnabled()) {
            String featureToggles = featureTogglesInfo.getFeatureToggles().map(ft -> ft.getName() + ": " + ft.isEnabled()).collect(Collectors.joining(","));
            logger.debug("Fetching the model for tenant '{}' and feature toggles '{}'", (Object)tenant, (Object)featureToggles);
        }
        Set features = featureTogglesInfo.getEnabledFeatureToggles().map(ft -> ft.getName()).collect(Collectors.toSet());
        ModelId modelId = ModelId.create((String)tenant).features(features).build();
        int maxAgeSeconds = Integer.MAX_VALUE;
        return this.accessor.getCdsModel(modelId, maxAgeSeconds);
    }
}

