/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.TargetAwareCqnModifier;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ImplicitSortingHandler
implements EventHandler {
    @Before
    @HandlerOrder(value=-10700)
    public void implicitSorting(CdsReadEventContext context) {
        CqnSelect select = context.getCqn();
        if (select.from().isRef()) {
            CqnSelect copy = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new OrderByModifier(context.getTarget(), select.hasLimit()));
            context.setCqn(copy);
        }
    }

    public static class OrderByModifier
    extends TargetAwareCqnModifier {
        private boolean mainOnlyFunctions = false;
        private List<CqnValue> mainGroupBy = Collections.emptyList();
        private boolean mainLimit = false;

        public OrderByModifier(CdsEntity target, boolean mainLimit) {
            super(target);
            this.mainLimit = mainLimit;
        }

        @Override
        protected TargetAwareCqnModifier create(CdsEntity target) {
            return new OrderByModifier(target, this.mainLimit);
        }

        public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
            this.mainOnlyFunctions = this.selectsFunctionsOrLiteralsOnly(items);
            return super.items(items);
        }

        public List<CqnValue> groupBy(List<CqnValue> groupBy) {
            this.mainGroupBy = groupBy;
            return super.groupBy(groupBy);
        }

        public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> orderBy) {
            return this.extendOrderBy(this.getTarget(), orderBy, this.mainOnlyFunctions, this.mainGroupBy, this.mainLimit);
        }

        @Override
        public CqnSelectListItem expand(CqnExpand expand) {
            CdsEntity refTarget = this.getRefTarget(expand.ref());
            if (refTarget != null) {
                List<CqnSortSpecification> orderBy = this.extendOrderBy(refTarget, new ArrayList<CqnSortSpecification>(expand.orderBy()), this.selectsFunctionsOrLiteralsOnly(expand.items()), Collections.emptyList(), expand.hasLimit());
                return CQL.copy((CqnExpand)expand).orderBy(orderBy);
            }
            return expand;
        }

        private List<CqnSortSpecification> extendOrderBy(CdsEntity target, List<CqnSortSpecification> orderBy, boolean onlyFunctions, List<CqnValue> groupBy, boolean limit) {
            if (onlyFunctions) {
                return orderBy;
            }
            HashSet sortItems = new HashSet();
            orderBy.stream().map(si -> si.value().toJson()).forEach(sortItems::add);
            if (groupBy.isEmpty()) {
                Object defaultOrder = CdsAnnotations.DEFAULT_ORDER.getOrDefault((CdsAnnotatable)target);
                this.handleDefaultOrderBy(defaultOrder, orderBy);
                target.query().ifPresent(view -> view.orderBy().stream().forEach(o -> {
                    String json = o.value().toJson();
                    if (!sortItems.contains(json)) {
                        sortItems.add(o.value().toJson());
                        orderBy.add(ExpressionVisitor.copy((CqnSortSpecification)o, (Modifier)new Modifier(){}));
                    }
                }));
            }
            if (limit) {
                if (groupBy.isEmpty()) {
                    target.keyElements().filter(e -> e.getType().isSimple()).filter(e -> !this.contains(e.getName(), orderBy)).map(e -> CQL.get((String)e.getName()).asc()).forEach(orderBy::add);
                } else {
                    groupBy.stream().flatMap(CqnValue::ofRef).filter(e -> !this.contains(e.path(), orderBy)).map(v -> CQL.get((List)v.segments()).asc()).forEach(orderBy::add);
                }
            }
            return orderBy;
        }

        private void handleDefaultOrderBy(Object value, List<CqnSortSpecification> orderBy) {
            if (value instanceof Map) {
                Map map = (Map)value;
                Object by = map.get("by");
                Object element = map.get("=");
                if (by instanceof Map) {
                    Object innerElement = ((Map)by).get("=");
                    if (innerElement instanceof String && !this.contains((String)innerElement, orderBy)) {
                        ElementRef val = CQL.get((String)((String)innerElement));
                        Object desc = map.get("desc");
                        CqnSortSpecification.Order order = CqnSortSpecification.Order.ASC;
                        if (Boolean.TRUE.equals(desc)) {
                            order = CqnSortSpecification.Order.DESC;
                        }
                        orderBy.add(CQL.sort((CqnValue)val, (CqnSortSpecification.Order)order));
                    }
                } else if (element instanceof String && !this.contains((String)element, orderBy)) {
                    orderBy.add(CQL.get((String)((String)element)).asc());
                }
            } else if (value instanceof List) {
                ((List)value).forEach(o -> this.handleDefaultOrderBy(o, orderBy));
            }
        }

        private boolean contains(String element, List<CqnSortSpecification> orderBy) {
            return orderBy.stream().anyMatch(c -> this.refNamed(c.value(), element));
        }

        private boolean refNamed(CqnValue val, String name) {
            if (!val.isRef()) {
                return false;
            }
            return name.equals(val.asRef().path());
        }

        private boolean selectsFunctionsOrLiteralsOnly(List<CqnSelectListItem> items) {
            return !items.isEmpty() && items.stream().allMatch(item -> item.isValue() && (item.asValue().value().isFunction() || item.asValue().value().isLiteral()));
        }
    }
}

