/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DraftModifier
implements Modifier {
    public static final String DRAFT_SUFFIX = "_drafts";
    private static final String SIBLING = "SiblingEntity";
    private final CdsEntity root;
    private final Boolean isActiveExecution;
    private final boolean addSecurityConstraints;
    private final boolean stripIsActiveEntity;
    private final EventContext context;
    private CdsEntity target;

    public DraftModifier(CdsEntity root, Boolean isActiveExecution, boolean addSecurityConstraints, boolean stripIsActiveEntity, EventContext context) {
        this.root = root;
        this.isActiveExecution = isActiveExecution;
        this.addSecurityConstraints = addSecurityConstraints;
        this.stripIsActiveEntity = stripIsActiveEntity;
        this.context = context;
    }

    private DraftModifier(DraftModifier copy, CdsEntity target) {
        this(copy.root, copy.isActiveExecution, copy.addSecurityConstraints, copy.stripIsActiveEntity, copy.context);
        this.target = target;
    }

    public CqnStructuredTypeRef ref(CqnStructuredTypeRef original) {
        CdsEntity entity = this.root;
        RefBuilder ref = CQL.copy((CqnStructuredTypeRef)original);
        RefBuilder.RefSegment rootSegment = ref.rootSegment();
        boolean startsWithEntity = entity.getQualifiedName().equals(rootSegment.id());
        if (this.isActiveExecution != null && startsWithEntity && DraftUtils.isDraftEnabled((CdsAnnotatable)entity)) {
            String id = rootSegment.id();
            if (this.isActiveExecution.booleanValue() && id.endsWith(DRAFT_SUFFIX)) {
                rootSegment.id(id.substring(0, id.length() - DRAFT_SUFFIX.length()));
                entity = (CdsEntity)entity.getTargetOf(SIBLING);
            } else if (!this.isActiveExecution.booleanValue() && !id.endsWith(DRAFT_SUFFIX)) {
                rootSegment.id(id + DRAFT_SUFFIX);
                entity = (CdsEntity)entity.getTargetOf(SIBLING);
                if (this.addSecurityConstraints) {
                    Predicate securityConstraints = DraftModifier.getSecurityConstraints(this.context);
                    rootSegment.filter((CqnPredicate)rootSegment.filter().map(f -> CQL.and((CqnPredicate)f, (CqnPredicate)securityConstraints)).orElse(securityConstraints));
                }
            }
        }
        for (RefBuilder.RefSegment segment : ref.segments()) {
            if (!startsWithEntity) {
                if (entity.findAssociation(segment.id()).isPresent()) {
                    entity = (CdsEntity)entity.getTargetOf(segment.id());
                } else {
                    if (!DraftUtils.isDraftEnabled((CdsAnnotatable)entity) || !segment.id().equals("*")) break;
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_EXPAND_ALL_IN_DRAFT, new Object[0]);
                }
            }
            startsWithEntity = false;
            if (!segment.filter().isPresent()) continue;
            segment.filter((CqnPredicate)CQL.copy((CqnPredicate)((CqnPredicate)segment.filter().get()), (Modifier)new DraftModifier(this, entity)));
        }
        this.target = entity;
        return (CqnStructuredTypeRef)ref.build();
    }

    public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        if ("DraftAdministrativeData".equals(this.target.getName())) {
            if (items.isEmpty()) {
                items.add((CqnSelectListItem)CQL.star());
            }
            if (items.stream().anyMatch(i -> i.isStar())) {
                items.add((CqnSelectListItem)this.buildInProcessByUserExpression((CqnElementRef)CQL.get((String)"InProcessByUser")).as("InProcessByUser"));
                items.add((CqnSelectListItem)this.buildDraftIsCreatedByMeExpression((CqnElementRef)CQL.get((String)"DraftIsCreatedByMe")).as("DraftIsCreatedByMe"));
                items.add((CqnSelectListItem)this.buildDraftIsProcessedByMeExpression((CqnElementRef)CQL.get((String)"DraftIsProcessedByMe")).as("DraftIsProcessedByMe"));
            }
        }
        return items;
    }

    public CqnValue ref(CqnElementRef ref) {
        if (this.stripIsActiveEntity && this.isIsActiveEntityOnActiveTarget(ref, this.target)) {
            return CQL.constant((Object)true);
        }
        if ("InProcessByUser".equals(ref.lastSegment())) {
            return this.buildInProcessByUserExpression(ref);
        }
        if ("DraftIsCreatedByMe".equals(ref.lastSegment())) {
            return this.buildDraftIsCreatedByMeExpression(ref);
        }
        if ("DraftIsProcessedByMe".equals(ref.lastSegment())) {
            return this.buildDraftIsProcessedByMeExpression(ref);
        }
        return ref;
    }

    private Value<?> buildInProcessByUserExpression(CqnElementRef ref) {
        Instant timeoutThreshold = DraftModifier.getCancellationThreshold(this.context);
        CqnElementRef refLastChangeDateTime = DraftModifier.changeLastSegment(ref, "LastChangeDateTime");
        CqnElementRef refDraftUuid = DraftModifier.changeLastSegment(ref, "DraftUUID");
        return ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("CASE WHEN").ref(refDraftUuid).plain("IS NULL THEN null WHEN").ref(refLastChangeDateTime).plain(">").add((CqnToken)CQL.constant((Object)timeoutThreshold)).plain("THEN").ref(ref).plain("ELSE '' END").value().type(CdsBaseType.STRING.cdsName());
    }

    private Value<?> buildDraftIsCreatedByMeExpression(CqnElementRef ref) {
        String user = this.context.getUserInfo().getName();
        CqnElementRef refCreatedByUser = DraftModifier.changeLastSegment(ref, "CreatedByUser");
        return ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("CASE WHEN").ref(refCreatedByUser).plain("=").add((CqnToken)CQL.val((Object)user)).plain("THEN true").plain("WHEN").ref(refCreatedByUser).plain("IS NULL").plain("THEN null ELSE false END").value().type(CdsBaseType.BOOLEAN.cdsName());
    }

    private Value<?> buildDraftIsProcessedByMeExpression(CqnElementRef ref) {
        String user = this.context.getUserInfo().getName();
        Instant timeoutThreshold = DraftModifier.getCancellationThreshold(this.context);
        CqnElementRef refCreatedByUser = DraftModifier.changeLastSegment(ref, "CreatedByUser");
        CqnElementRef refLastChangeDateTime = DraftModifier.changeLastSegment(ref, "LastChangeDateTime");
        return ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("CASE WHEN").ref(refCreatedByUser).plain("=").add((CqnToken)CQL.val((Object)user)).plain("AND").ref(refLastChangeDateTime).plain(">").add((CqnToken)CQL.constant((Object)timeoutThreshold)).plain("THEN true").plain("WHEN").ref(refCreatedByUser).plain("IS NULL").plain("THEN null ELSE false END").value().type(CdsBaseType.BOOLEAN.cdsName());
    }

    public CqnSelectListItem selectListValue(Value<?> value, String alias) {
        if (value.isExpression() && alias == null) {
            String type = value.type().orElse(null);
            if (CdsBaseType.STRING.cdsName().equals(type)) {
                alias = "InProcessByUser";
            } else if (CdsBaseType.BOOLEAN.cdsName().equals(type)) {
                alias = value.tokens().anyMatch(t -> t.toString().equals("\"AND\"")) ? "DraftIsProcessedByMe" : "DraftIsCreatedByMe";
            }
        }
        return value.as(alias);
    }

    public CqnSelectListItem expand(CqnExpand expand) {
        DraftModifier modifier = new DraftModifier(this.target, null, this.addSecurityConstraints, this.stripIsActiveEntity, this.context);
        StructuredTypeRef ref = ExpressionVisitor.copy((CqnStructuredTypeRef)expand.ref(), (Modifier)modifier);
        List items = modifier.items(expand.items().stream().map(i -> ExpressionVisitor.copy((CqnSelectListItem)i, (Modifier)modifier)).collect(Collectors.toList()));
        List orderBy = modifier.orderBy(expand.orderBy().stream().map(o -> ExpressionVisitor.copy((CqnSortSpecification)o, (Modifier)modifier)).collect(Collectors.toList()));
        Expand copy = CQL.to((List)ref.segments()).as((String)ref.alias().orElse(null)).expand((Iterable)items).orderBy(orderBy).limit(expand.top(), expand.skip()).inlineCount(expand.hasInlineCount());
        if (((ExpandBuilder)expand).lazy()) {
            ((ExpandBuilder)copy).lazy(true);
        }
        return copy;
    }

    public CqnSelectListItem inline(CqnInline inline) {
        DraftModifier modifier = new DraftModifier(this.target, null, this.addSecurityConstraints, this.stripIsActiveEntity, this.context);
        StructuredTypeRef refCopy = ExpressionVisitor.copy((CqnStructuredTypeRef)inline.ref(), (Modifier)modifier);
        List itemsCopy = modifier.items(inline.items().stream().map(i -> ExpressionVisitor.copy((CqnSelectListItem)i, (Modifier)modifier)).collect(Collectors.toList()));
        return CQL.to((List)refCopy.segments()).inline((Iterable)itemsCopy);
    }

    private boolean isIsActiveEntityOnActiveTarget(CqnElementRef ref, CdsEntity entity) {
        if ("IsActiveEntity".equals(ref.lastSegment())) {
            for (CqnReference.Segment segment : ref.segments()) {
                String id = segment.id();
                if (!entity.findAssociation(id).isPresent()) continue;
                entity = (CdsEntity)entity.getTargetOf(id);
            }
            return !entity.getQualifiedName().endsWith(DRAFT_SUFFIX);
        }
        return false;
    }

    private static CqnElementRef changeLastSegment(CqnElementRef ref, String id) {
        ArrayList<CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>(ref.segments());
        segments.set(segments.size() - 1, CQL.refSegment((String)id));
        return CQL.get(segments);
    }

    static Instant getCancellationThreshold(EventContext context) {
        return Instant.now().minus(context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().getCancellationTimeout()).truncatedTo(ChronoUnit.MILLIS);
    }

    static Predicate getSecurityConstraints(EventContext context) {
        if (!context.getCdsRuntime().getEnvironment().getCdsProperties().getSecurity().getAuthorization().getDraftProtection().isEnabled().booleanValue() || context.getUserInfo().isPrivileged()) {
            return CqnBoolLiteral.TRUE;
        }
        return CQL.exists((CqnSelect)Select.from((String)"DRAFT.DraftAdministrativeData").where(e -> e.get("DraftUUID").eq((Value)CQL.to((String)"$outer").get("DraftAdministrativeData_DraftUUID")).and((CqnPredicate)CQL.or((CqnPredicate)e.get("CreatedByUser").isNull(), (CqnPredicate)e.get("CreatedByUser").eq((Object)context.getUserInfo().getName())), new CqnPredicate[0])));
    }

    static CdsEntity getDraftsEntity(CdsEntity entity, CdsModel model) {
        if (entity.getName().endsWith(DRAFT_SUFFIX)) {
            return entity;
        }
        return model.getEntity(entity.getQualifiedName() + DRAFT_SUFFIX);
    }
}

