package com.sap.cds.services.impl.aot;

import java.lang.reflect.Method;

import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeProxyCreation;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

import com.sap.cds.CdsData;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.EventContextSPI;

public class CdsAotFeature implements Feature {

	@Override
	public void beforeAnalysis(BeforeAnalysisAccess access) {
		// EventContext proxies
		access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
			// TODO avoid registering proxies for event contexts with concrete implementations
			if (clazz.isInterface() && !clazz.equals(EventContext.class) && !clazz.equals(EventContextSPI.class)) {
				RuntimeProxyCreation.register(clazz);
				RuntimeProxyCreation.register(clazz, EventContextSPI.class);
			}
		}, EventContext.class);

		// CdsData proxies
		access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
			if (clazz.isInterface()) {
				RuntimeProxyCreation.register(clazz);
			}
		}, CdsData.class);

		// StructuredType proxies
		access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
			if (clazz.isInterface() && !clazz.equals(StructuredType.class)) {
				RuntimeProxyCreation.register(clazz);
			}
		}, StructuredType.class);

		// Event Handlers
		access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
			registerEventHandlersForReflection(clazz);
		}, EventHandler.class);

		access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
			registerEventHandlersForReflection(clazz);
		}, Service.class);
	}

	private void registerEventHandlersForReflection(Class<?> clazz) {
		for (Method m : clazz.getDeclaredMethods()) {
			if (m.isAnnotationPresent(Before.class) || m.isAnnotationPresent(On.class) || m.isAnnotationPresent(After.class)) {
				RuntimeReflection.register(m);
			} else {
				RuntimeReflection.registerAsQueried(m);
			}
		}
	}

}
