/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.authorization.ActionAccessEventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.CalcWhereConditionEventContext;
import com.sap.cds.services.authorization.EntityAccessEventContext;
import com.sap.cds.services.authorization.FunctionAccessEventContext;
import com.sap.cds.services.authorization.ServiceAccessEventContext;

public class AuthorizationServiceImpl extends ServiceDelegator implements AuthorizationService {

	public AuthorizationServiceImpl(String name) {
		super(name);
	}

	@Override
	public boolean hasServiceAccess(String serviceName, String event) {

		ServiceAccessEventContext context = ServiceAccessEventContext.create();
		context.setAccessServiceName(serviceName);
		context.setAccessEventName(event);

		emit(context);

		Boolean result = context.getResult();
		return result != null ? result : false;
	}

	@Override
	public boolean hasEntityAccess(String entityName, String event) {
		return hasEntityAccess(entityName, event, null);
	}

	@Override
	public boolean hasEntityAccess(String entityName, String event, CqnStatement query) {

		EntityAccessEventContext context = EntityAccessEventContext.create(entityName);
		context.setAccessQuery(query);
		context.setAccessEntityName(entityName);
		context.setAccessEventName(event);

		emit(context);

		Boolean result = context.getResult();
		return result != null ? result : false;
	}

	@Override
	public boolean hasFunctionAccess(String entityName, String functionName) {

		FunctionAccessEventContext context = FunctionAccessEventContext.create();
		context.setFunctionName(functionName);
		context.setEntityName(entityName);

		emit(context);

		Boolean result = context.getResult();
		return result != null ? result : false;
	}

	@Override
	public boolean hasActionAccess(String entityName, String actionName) {

		ActionAccessEventContext context = ActionAccessEventContext.create();
		context.setActionName(actionName);
		context.setEntityName(entityName);

		emit(context);

		Boolean result = context.getResult();
		return result != null ? result : false;
	}

	@Override
	public CqnPredicate calcWhereCondition(String entityName, String event) {

		CalcWhereConditionEventContext context = CalcWhereConditionEventContext.create(entityName);
		context.setEntityName(entityName);
		context.setEventName(event);

		emit(context);

		return context.getResult();
	}

}
