/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.impl.ContextualizedServiceException;
import com.sap.cds.services.impl.EventContextSPI;
import com.sap.cds.services.impl.EventPredicate;
import com.sap.cds.services.impl.Phase;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.handlerregistry.EventPredicateTools;
import com.sap.cds.services.impl.handlerregistry.HandlerRegistryTools;
import com.sap.cds.services.impl.runtime.ChangeSetContextRunnerImpl;
import com.sap.cds.services.impl.runtime.RequestContextRunnerImpl;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.impl.utils.OpenTelemetryUtils;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImpl
implements ServiceSPI {
    private static final Logger logger = LoggerFactory.getLogger(ServiceImpl.class);
    private static final Handler DEFAULT_REJECT = context -> {
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_ON_HANDLER, new Object[0]);
    };
    private final String name;
    private final List<Registration> beforeRegistrations = new CopyOnWriteArrayList<Registration>();
    private final List<Registration> onRegistrations = new CopyOnWriteArrayList<Registration>();
    private final List<Registration> afterRegistrations = new CopyOnWriteArrayList<Registration>();
    private final Service delegator;
    private CdsRuntime runtime = null;

    public ServiceImpl(String name) {
        this(name, null);
    }

    public ServiceImpl(String name, Service delegator) {
        if (StringUtils.isEmpty((String)name)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NAME_REQUIRED, new Object[0]);
        }
        this.name = name.trim();
        this.delegator = delegator == null ? this : delegator;
        this.registerHandler(Phase.ON, EventPredicate.ALL, DEFAULT_REJECT, Integer.MAX_VALUE);
        HandlerRegistryTools.registerInstance(this.delegator, this);
    }

    @Override
    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public CdsRuntime getCdsRuntime() {
        return this.runtime;
    }

    public void before(String[] events, String[] entities, int order, Handler handler) {
        this.registerHandler(Phase.BEFORE, EventPredicateTools.create(events, entities), handler, order);
    }

    public void on(String[] events, String[] entities, int order, Handler handler) {
        this.registerHandler(Phase.ON, EventPredicateTools.create(events, entities), handler, order);
    }

    public void after(String[] events, String[] entities, int order, Handler handler) {
        this.registerHandler(Phase.AFTER, EventPredicateTools.create(events, entities), handler, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHandler(Phase phase, EventPredicate predicate, Handler handler, int order) {
        List<Registration> reg;
        List<Registration> list = reg = this.getRegistration(phase);
        synchronized (list) {
            int index;
            int end = reg.size();
            for (index = 0; index < end && order >= reg.get((int)index).order; ++index) {
            }
            reg.add(index, new Registration(predicate, handler, order));
        }
    }

    private List<Registration> getRegistration(Phase phase) {
        switch (phase) {
            case BEFORE: {
                return this.beforeRegistrations;
            }
            case ON: {
                return this.onRegistrations;
            }
            case AFTER: {
                return this.afterRegistrations;
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNKNOWN_EVENT_PHASE, new Object[]{phase});
    }

    public void emit(EventContext context) {
        Objects.requireNonNull(context, "context must not be null");
        String entityName = CdsModelUtils.getNameOrEmpty(context.getTarget());
        logger.debug("Started emit of '{}' for event '{}', entity '{}'", new Object[]{this.getName(), context.getEvent(), entityName});
        Optional<Span> span = OpenTelemetryUtils.createSpan(OpenTelemetryUtils.CdsSpanType.EMIT);
        OpenTelemetryUtils.updateSpan(span, this.getName(), context.getEvent(), entityName);
        try (Scope scope = span.map(ImplicitContextKeyed::makeCurrent).orElse(null);){
            EventContextSPI innerContext = CdsServiceUtils.getEventContextSPI(context);
            if (innerContext != null) {
                innerContext.setService(this.delegator);
            }
            boolean hasRequestContext = RequestContext.isActive();
            boolean hasChangeSetContext = ChangeSetContext.isActive();
            if (hasRequestContext && hasChangeSetContext) {
                this.dispatch(context);
            } else if (!hasRequestContext) {
                new RequestContextRunnerImpl(this.runtime).run(requestContext -> {
                    if (hasChangeSetContext) {
                        this.dispatch(context);
                    } else {
                        this.dispatchInChangeSetContext(context);
                    }
                });
            } else {
                this.dispatchInChangeSetContext(context);
            }
        }
        catch (Exception e) {
            OpenTelemetryUtils.recordException(span, e);
            throw e;
        }
        finally {
            OpenTelemetryUtils.endSpan(span);
        }
        logger.debug("Finished emit of '{}' for event '{}', entity '{}'", new Object[]{this.getName(), context.getEvent(), entityName});
    }

    protected void dispatchInChangeSetContext(EventContext context) {
        new ChangeSetContextRunnerImpl(this.runtime).run(changeSetContext -> this.dispatch(context));
    }

    protected void dispatch(EventContext context) {
        String eventName = context.getEvent();
        String entityName = CdsModelUtils.getNameOrEmpty(context.getTarget());
        if (context.isCompleted()) {
            logger.warn("Tried to dispatch a completed context (service '{}', event '{}', entity '{}')", new Object[]{this.getName(), eventName, entityName});
            return;
        }
        try {
            for (Registration registration : this.beforeRegistrations) {
                if (!registration.predicate.test(eventName, entityName)) continue;
                this.logHandlerExecution(registration, eventName, entityName, Phase.BEFORE);
                registration.handler.process(context);
                if (!context.isCompleted()) continue;
                break;
            }
            if (!context.isCompleted()) {
                for (Registration registration : this.onRegistrations) {
                    if (!registration.predicate.test(eventName, entityName)) continue;
                    this.logHandlerExecution(registration, eventName, entityName, Phase.ON);
                    registration.handler.process(context);
                    if (!context.isCompleted()) continue;
                    break;
                }
            }
            for (Registration registration : this.afterRegistrations) {
                if (!registration.predicate.test(eventName, entityName)) continue;
                this.logHandlerExecution(registration, eventName, entityName, Phase.AFTER);
                registration.handler.process(context);
            }
        }
        catch (ContextualizedServiceException e) {
            e.via(context);
            throw e;
        }
        catch (Exception e) {
            throw new ContextualizedServiceException(context, e);
        }
    }

    private void logHandlerExecution(Registration registration, String eventName, String entityName, Phase phase) {
        logger.debug("Executing {} handler '{}' (order {}) for event '{}' on service '{}' and entity '{}'", new Object[]{phase, registration.handler, registration.order, eventName, this.getName(), entityName});
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Stream<ServiceSPI.HandlerRegistration> registrations(Phase phase) {
        return this.getRegistration(phase).stream().map(r -> r);
    }

    private static class Registration
    implements ServiceSPI.HandlerRegistration {
        public final EventPredicate predicate;
        public final Handler handler;
        public final int order;

        public Registration(EventPredicate predicate, Handler handler, int order) {
            this.predicate = Objects.requireNonNull(predicate, "predicate must not be null");
            this.handler = Objects.requireNonNull(handler, "handler must not be null");
            this.order = order;
        }

        @Override
        public EventPredicate getEventPredicate() {
            return this.predicate;
        }

        @Override
        public Handler getHandler() {
            return this.handler;
        }

        @Override
        public int getOrder() {
            return this.order;
        }
    }
}

