/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={AuditLogService.class})
class AuditLogDefaultOnHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuditLogDefaultOnHandler.class);

    AuditLogDefaultOnHandler() {
    }

    @On
    @HandlerOrder(value=11000)
    public void handleDataAccessEvent(DataAccessLogContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("DataAccess: {}", (Object)context.getData().toJson());
        }
    }

    @On
    @HandlerOrder(value=11000)
    public void handleDataModificationEvent(DataModificationLogContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("DataModification: {}", (Object)context.getData().toJson());
        }
    }

    @On
    @HandlerOrder(value=11000)
    public void handleConfigChangeEvent(ConfigChangeLogContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ConfigChange: {}", (Object)context.getData().toJson());
        }
    }

    @On
    @HandlerOrder(value=11000)
    public void handleSecurityEvent(SecurityLogContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SecurityEvent: {}", (Object)context.getData().toJson());
        }
    }
}

