/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Result;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.DataModification;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.auditlog.PersonalDataAnalyzerModification;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataModifier;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

@ServiceName(value={"*"}, type={PersistenceService.class})
class PersistenceServicePersonalDataHandler
implements EventHandler {
    private static final String PD_ANALYZER_MODIFICATION_KEY = PersonalDataAnalyzerModification.class.getCanonicalName();
    private final PersonalDataCaches caches;
    private final CdsRuntime runtime;
    private final AuditLogService auditLog;

    PersistenceServicePersonalDataHandler(PersonalDataCaches caches, CdsRuntime runtime) {
        this.caches = Objects.requireNonNull(caches, "caches must not be null");
        this.runtime = Objects.requireNonNull(runtime, "runtime must not be null");
        this.auditLog = (AuditLogService)runtime.getServiceCatalog().getService(AuditLogService.class, "AuditlogService$Default");
    }

    @After
    @HandlerOrder(value=-10900)
    protected void afterCreate(CdsCreateEventContext context) {
        CdsEntity entity;
        PersonalDataAnalyzerModification pdAnalyzer;
        if (context.getResult() != null && (pdAnalyzer = new PersonalDataAnalyzerModification(entity = context.getTarget(), context.getResult().list(), this.caches, this.runtime)).hasPersonalData()) {
            ArrayList data = new ArrayList();
            for (CdsData row : context.getResult().list()) {
                Map<String, Object> matcher = this.caches.getMeta((CdsStructuredType)entity).getKeys((Map<String, Object>)row);
                Select select = Select.from((CdsEntity)entity).matching(matcher).columns(this.getItemsForUpdatedData(entity, Arrays.asList(row)));
                Result result = context.getService().run((CqnSelect)select, new Object[0]);
                data.addAll(result.list());
            }
            pdAnalyzer.setData(data);
            List<DataModification> modifications = pdAnalyzer.getDataModifications();
            if (!modifications.isEmpty()) {
                this.auditLog.logDataModification(modifications);
            }
        }
    }

    @Before
    @HandlerOrder(value=11300)
    protected void beforeUpdate(CdsUpdateEventContext context, List<CdsData> newData) {
        CdsEntity entity;
        PersonalDataAnalyzerModification pdAnalyzer;
        if (!newData.isEmpty() && (pdAnalyzer = new PersonalDataAnalyzerModification(entity = context.getTarget(), newData, this.caches, this.runtime)).hasPersonalData()) {
            ArrayList oldData = new ArrayList();
            for (CdsData row : newData) {
                Select<?> select = this.createSelectFromUpdate(context, row);
                Result result = context.getService().run(select, new Object[0]);
                oldData.addAll(result.list());
            }
            pdAnalyzer.setOldData(oldData);
            context.put(PD_ANALYZER_MODIFICATION_KEY, (Object)pdAnalyzer);
        }
    }

    @After
    @HandlerOrder(value=-10900)
    protected void afterUpdate(CdsUpdateEventContext context) {
        PersonalDataAnalyzerModification pdAnalyzer = (PersonalDataAnalyzerModification)context.get(PD_ANALYZER_MODIFICATION_KEY);
        if (pdAnalyzer != null && context.getResult().rowCount() > 0L) {
            context.put(PD_ANALYZER_MODIFICATION_KEY, null);
            ArrayList data = new ArrayList();
            for (CdsData row : context.getResult().list()) {
                Select<?> select = this.createSelectFromUpdate(context, row);
                Result result = context.getService().run(select, new Object[0]);
                data.addAll(result.list());
            }
            pdAnalyzer.setData(data);
            List<DataModification> modifications = pdAnalyzer.getDataModifications();
            if (!modifications.isEmpty()) {
                this.auditLog.logDataModification(modifications);
            }
        }
    }

    @Before
    @HandlerOrder(value=11300)
    protected void beforeDelete(CdsDeleteEventContext context) {
        CdsEntity entity = context.getTarget();
        if (this.caches.getUtils((CdsStructuredType)entity).hasPersonalDataDeleted()) {
            PersonalDataAnalyzerModification pdAnalyzer = new PersonalDataAnalyzerModification((CdsStructuredType)entity, this.caches, this.runtime);
            Select selectEntity = CqnUtils.toSelect((CqnDelete)context.getCqn()).columns((Function[])this.caches.getUtils((CdsStructuredType)entity).expandCompositionsForDelete());
            PersonalDataModifier modifier = new PersonalDataModifier(entity, true, this.caches);
            CqnSelect select = (CqnSelect)CQL.copy((CqnStatement)PersistenceServicePersonalDataHandler.modifySelectStatement(entity, (CqnSelect)selectEntity), (Modifier)modifier);
            List oldData = context.getService().run(select, new Object[0]).list();
            pdAnalyzer.setOldData(oldData);
            context.put(PD_ANALYZER_MODIFICATION_KEY, (Object)pdAnalyzer);
        }
    }

    @After
    @HandlerOrder(value=-10900)
    protected void afterDelete(CdsDeleteEventContext context) {
        PersonalDataAnalyzerModification pdAnalyzer = (PersonalDataAnalyzerModification)context.get(PD_ANALYZER_MODIFICATION_KEY);
        if (pdAnalyzer != null) {
            context.put(PD_ANALYZER_MODIFICATION_KEY, null);
            List<DataModification> modifications = pdAnalyzer.getDataModifications();
            if (!modifications.isEmpty()) {
                this.auditLog.logDataModification(modifications);
            }
        }
    }

    private Select<?> createSelectFromUpdate(CdsUpdateEventContext context, CdsData row) {
        Select select;
        CdsEntity entity = context.getTarget();
        Map<String, Object> matcher = this.caches.getMeta((CdsStructuredType)entity).getKeys((Map<String, Object>)row);
        List<CqnSelectListItem> itemsToSelect = this.getItemsForUpdatedData(entity, Arrays.asList(row));
        if (!matcher.isEmpty()) {
            select = Select.from((CdsEntity)entity).matching(matcher).columns(itemsToSelect);
        } else {
            CqnUpdate update = context.getCqn();
            select = Select.from((CqnStructuredTypeRef)update.ref()).columns(itemsToSelect);
            update.where().ifPresent(arg_0 -> ((Select)select).where(arg_0));
        }
        return select;
    }

    private List<CqnSelectListItem> getItemsForUpdatedData(CdsEntity entity, Iterable<? extends Map<String, Object>> dataList) {
        LinkedList<CqnSelectListItem> items = new LinkedList<CqnSelectListItem>();
        HashSet<String> fieldsToSelect = new HashSet<String>();
        entity.keyElements().forEach(key -> fieldsToSelect.add(key.getName()));
        this.caches.getUtils((CdsStructuredType)entity).resolveDataSubjectId().forEach(items::add);
        HashMap<String, List> associations = new HashMap<String, List>();
        for (Map<String, Object> map : dataList) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                CdsType type = entity.getElement(entry.getKey()).getType();
                if (type.isSimple() || type.isArrayed()) {
                    Set<String> personalDataFields = this.caches.getMeta((CdsStructuredType)entity).getPersonalDataNames();
                    if (!personalDataFields.contains(entry.getKey())) continue;
                    fieldsToSelect.add(entry.getKey());
                    continue;
                }
                if (!type.isAssociation()) continue;
                if (((CdsAssociationType)type.as(CdsAssociationType.class)).getCardinality().getTargetMax().equals("*")) {
                    if (!associations.containsKey(entry.getKey())) {
                        associations.put(entry.getKey(), new ArrayList((List)entry.getValue()));
                        continue;
                    }
                    ((List)associations.get(entry.getKey())).addAll((List)entry.getValue());
                    continue;
                }
                if (!associations.containsKey(entry.getKey())) {
                    associations.put(entry.getKey(), Arrays.asList((Map)entry.getValue()));
                    continue;
                }
                ((List)associations.get(entry.getKey())).add((Map)entry.getValue());
            }
        }
        fieldsToSelect.forEach(field -> items.add((CqnSelectListItem)CQL.get((String)field)));
        associations.forEach((assoc, entries) -> {
            List<CqnSelectListItem> toExpand = this.getItemsForUpdatedData((CdsEntity)entity.getTargetOf(assoc), (Iterable<? extends Map<String, Object>>)entries);
            if (toExpand != null) {
                items.add((CqnSelectListItem)CQL.to((String)assoc).expand(toExpand));
            }
        });
        return items;
    }

    private static CqnSelect modifySelectStatement(CdsEntity entity, CqnSelect select) {
        CqnSelect newSelect = (CqnSelect)CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)entity, (CqnStatement)select);
        newSelect = CqnStatementUtils.resolveStar((CqnSelect)newSelect, (CdsStructuredType)entity);
        return newSelect;
    }
}

