/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.util.ConstantLiteralSealingModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;

public class PredicateResolver {
    static final Predicate UNRESTRICTED_PRED = CQL.constant((Object)1).eq((Value)CQL.constant((Object)1));
    static final Predicate RESTRICTED_PRED = CQL.constant((Object)1).eq((Value)CQL.constant((Object)0));
    private static final ConstantLiteralSealingModifier LITERAL_SEALING_MODIFIER = new ConstantLiteralSealingModifier();
    private final boolean emptyAttributesAreRestricted;
    private final CqnPredicate unresolvedPred;

    private PredicateResolver(CqnPredicate pred, boolean emptyAttributesAreRestricted) {
        this.unresolvedPred = pred;
        this.emptyAttributesAreRestricted = emptyAttributesAreRestricted;
    }

    static PredicateResolver create(String cxnExpression, boolean emptyAttributesAreRestricted) {
        Predicate pred = !StringUtils.isEmpty((String)cxnExpression) ? PredicateResolver.parsePredicate(cxnExpression) : UNRESTRICTED_PRED;
        return new PredicateResolver((CqnPredicate)pred, emptyAttributesAreRestricted);
    }

    CqnPredicate resolve(UserInfo user) {
        return CQL.copy((CqnPredicate)this.unresolvedPred, (Modifier)new UserAttributeSubstitutor(user, this.emptyAttributesAreRestricted));
    }

    private static CqnPredicate parsePredicate(String cxnExpression) {
        return ExpressionVisitor.copy((CqnPredicate)ExpressionParser.parsePredicate((String)cxnExpression), (Modifier)LITERAL_SEALING_MODIFIER);
    }

    private static class UserAttributeSubstitutor
    implements Modifier {
        private static final String USER = "$user";
        private static final String TENANT = "tenant";
        private static List<CqnValue> UNRESTRICTED_VALUE = Arrays.asList(new CqnValue[0]);
        private static List<CqnValue> RESTRICTED_VALUE = Arrays.asList(new CqnValue[0]);
        private static List<CqnValue> UNRESOLVED_EMPTY_VALUE = Arrays.asList(new CqnValue[0]);
        private final boolean emptyAttributesAreRestricted;
        private final UserInfo userInfo;

        public UserAttributeSubstitutor(UserInfo userInfo, boolean emptyAttributesAreRestricted) {
            this.userInfo = userInfo;
            this.emptyAttributesAreRestricted = emptyAttributesAreRestricted;
        }

        private List<CqnValue> ensureNormalizedValue(List<CqnValue> value) {
            if (value == UNRESOLVED_EMPTY_VALUE) {
                return this.emptyAttributesAreRestricted ? RESTRICTED_VALUE : UNRESTRICTED_VALUE;
            }
            return value;
        }

        public Predicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
            MutablePair<List<CqnValue>, Boolean> lhsValuesRaw = this.resolveUserValuesRaw((CqnValue)lhs);
            List<CqnValue> lhsValues = (List<CqnValue>)lhsValuesRaw.getLeft();
            boolean isUserAttribute = (Boolean)lhsValuesRaw.getRight();
            if (isUserAttribute && rhs.isNullValue()) {
                if (op == CqnComparisonPredicate.Operator.IS) {
                    return lhsValues == UNRESOLVED_EMPTY_VALUE ? UNRESTRICTED_PRED : RESTRICTED_PRED;
                }
                if (op == CqnComparisonPredicate.Operator.IS_NOT) {
                    return lhsValues != UNRESOLVED_EMPTY_VALUE ? UNRESTRICTED_PRED : RESTRICTED_PRED;
                }
            }
            lhsValues = this.ensureNormalizedValue(lhsValues);
            List<CqnValue> rhsValues = this.resolveUserValues((CqnValue)rhs);
            if (lhsValues == RESTRICTED_VALUE || rhsValues == RESTRICTED_VALUE) {
                return RESTRICTED_PRED;
            }
            if (lhsValues == UNRESTRICTED_VALUE || rhsValues == UNRESTRICTED_VALUE) {
                return UNRESTRICTED_PRED;
            }
            ArrayList<Predicate> preds = new ArrayList<Predicate>(lhsValues.size() * rhsValues.size());
            for (CqnValue lhsVal : lhsValues) {
                for (CqnValue rhsVal : rhsValues) {
                    preds.add(CQL.comparison((CqnValue)lhsVal, (CqnComparisonPredicate.Operator)op, (CqnValue)rhsVal));
                }
            }
            return CQL.or(preds);
        }

        public Predicate in(Value<?> value, CqnValue valueSet) {
            List<Object> rhsValues;
            List<CqnValue> lhsValues = this.resolveUserValues((CqnValue)value);
            if (lhsValues == RESTRICTED_VALUE) {
                return RESTRICTED_PRED;
            }
            if (lhsValues == UNRESTRICTED_VALUE) {
                return UNRESTRICTED_PRED;
            }
            if (valueSet.isList()) {
                rhsValues = new ArrayList();
                for (CqnValue listValue : valueSet.asList().values().collect(Collectors.toList())) {
                    List<CqnValue> listValues = this.resolveUserValues(listValue);
                    if (listValues == RESTRICTED_VALUE) {
                        return RESTRICTED_PRED;
                    }
                    if (listValues == UNRESTRICTED_VALUE) {
                        return UNRESTRICTED_PRED;
                    }
                    rhsValues.addAll(listValues);
                }
            } else {
                rhsValues = this.resolveUserValues(valueSet);
                if (rhsValues == RESTRICTED_VALUE) {
                    return RESTRICTED_PRED;
                }
                if (rhsValues == UNRESTRICTED_VALUE) {
                    return UNRESTRICTED_PRED;
                }
            }
            return CQL.or((Iterable)lhsValues.stream().map(v -> CQL.in((CqnValue)v, (Collection)rhsValues)).collect(Collectors.toList()));
        }

        public CqnPredicate exists(Select<?> subQuery) {
            subQuery.where().ifPresent(w -> subQuery.where((CqnPredicate)CQL.copy((CqnPredicate)w, (Modifier)this)));
            return super.exists(subQuery);
        }

        public CqnPredicate match(CqnMatchPredicate match) {
            if (match.predicate().isPresent()) {
                Predicate pred = CQL.copy((CqnPredicate)((CqnPredicate)match.predicate().get()), (Modifier)this);
                return CQL.match((CqnStructuredTypeRef)match.ref(), (CqnPredicate)pred, (CqnMatchPredicate.Quantifier)match.quantifier());
            }
            return match;
        }

        public CqnValue function(String name, List<Value<?>> args, String cdsType) {
            for (int i = 0; i < args.size(); ++i) {
                List<CqnValue> resolvedValue = this.resolveUserValues((CqnValue)args.get(i));
                if (resolvedValue.size() != 1) {
                    throw new MultipleAttributeValuesNotSupportedException(name, this.extractUserAttribute((CqnValue)args.get(i)));
                }
                args.set(i, (Value)resolvedValue.get(0));
            }
            return super.function(name, args, cdsType);
        }

        public CqnPredicate booleanFunction(String name, List<Value<?>> args) {
            for (int i = 0; i < args.size(); ++i) {
                List<CqnValue> resolvedValue = this.resolveUserValues((CqnValue)args.get(i));
                if (resolvedValue.size() != 1) {
                    throw new MultipleAttributeValuesNotSupportedException(name, this.extractUserAttribute((CqnValue)args.get(i)));
                }
                args.set(i, (Value)resolvedValue.get(0));
            }
            return super.booleanFunction(name, args);
        }

        private List<CqnValue> resolveUserValues(CqnValue val) {
            return this.ensureNormalizedValue((List)this.resolveUserValuesRaw(val).getLeft());
        }

        private MutablePair<List<CqnValue>, Boolean> resolveUserValuesRaw(CqnValue val) {
            String userAttribute = this.extractUserAttribute(val);
            if (userAttribute == null) {
                return MutablePair.of(Arrays.asList(val), (Object)false);
            }
            List<Object> result = null;
            switch (userAttribute) {
                case "$user": {
                    result = !StringUtils.isEmpty((String)this.userInfo.getName()) ? Arrays.asList(CQL.constant((Object)this.userInfo.getName())) : RESTRICTED_VALUE;
                    break;
                }
                case "tenant": {
                    result = !StringUtils.isEmpty((String)this.userInfo.getTenant()) ? Arrays.asList(CQL.constant((Object)this.userInfo.getTenant())) : RESTRICTED_VALUE;
                    break;
                }
                default: {
                    List attributeValues = this.userInfo.getAttributeValues(userAttribute);
                    result = attributeValues == null || attributeValues.isEmpty() ? UNRESOLVED_EMPTY_VALUE : attributeValues.stream().map(v -> CQL.constant((Object)v)).collect(Collectors.toList());
                }
            }
            return MutablePair.of(result, (Object)true);
        }

        private String extractUserAttribute(CqnValue val) {
            List segments;
            if (val.isRef() && !(segments = val.asRef().segments()).isEmpty() && USER.equalsIgnoreCase(((CqnReference.Segment)segments.get(0)).id())) {
                if (segments.size() == 1) {
                    return USER;
                }
                String attribute = ((CqnReference.Segment)segments.get(1)).id();
                if (TENANT.equalsIgnoreCase(attribute)) {
                    return TENANT;
                }
                return attribute;
            }
            return null;
        }
    }

    public static class MultipleAttributeValuesNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String attributeName;
        private final String resourceName;

        MultipleAttributeValuesNotSupportedException(String resourceName, String attributeName) {
            this.resourceName = resourceName;
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

