/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.Restriction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class RestrictionLookup {
    private final Map<String, Restriction> cachedRestrictions = new ConcurrentHashMap<String, Restriction>();
    private static final Restriction undefined = new Restriction();

    public Restriction retrieveServiceRestriction(CdsModel model, String serviceName) {
        return this.lookupRestriction(serviceName, name -> com.sap.cds.services.utils.model.CdsModelUtils.getRestrictionOrNull((CdsAnnotatable)CdsModelUtils.getServiceOrThrow(model, name)));
    }

    public Restriction retrieveEntityRestriction(CdsModel model, String entityName) {
        return this.lookupRestriction(entityName, name -> com.sap.cds.services.utils.model.CdsModelUtils.getRestrictionOrNull((CdsAnnotatable)CdsModelUtils.getEntityOrThrow(model, name)));
    }

    public Restriction lookupFunctionRestriction(CdsModel model, String entityName, String functionName) {
        String key = entityName != null ? entityName + "." + functionName : functionName;
        return this.lookupRestriction(key, name -> com.sap.cds.services.utils.model.CdsModelUtils.getRestrictionOrNull((CdsAnnotatable)((CdsAnnotatable)CdsModelUtils.getFunction(model, entityName, functionName).orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FUNCTION_NOT_FOUND, new Object[]{functionName})))));
    }

    public Restriction lookupActionRestriction(CdsModel model, String entityName, String actionName) {
        String key = entityName != null ? entityName + "." + actionName : actionName;
        return this.lookupRestriction(key, name -> com.sap.cds.services.utils.model.CdsModelUtils.getRestrictionOrNull((CdsAnnotatable)((CdsAnnotatable)CdsModelUtils.getAction(model, entityName, actionName).orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ACTION_NOT_FOUND, new Object[]{actionName})))));
    }

    private Restriction lookupRestriction(String name, Function<String, Restriction> resolver) {
        Restriction cachedRestriction = this.cachedRestrictions.get(name);
        if (cachedRestriction == null) {
            cachedRestriction = resolver.apply(name);
            this.cachedRestrictions.put(name, cachedRestriction == null ? undefined : cachedRestriction);
        }
        return cachedRestriction == undefined ? null : cachedRestriction;
    }
}

