/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.Row;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CqnStatementUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DraftReader {
    private static final String ADDED_COLUMN_PREFIX = "ADDED_FOR_DRAFT_SORTING_";
    private final EventContext context;

    public static DraftReader create(EventContext context) {
        return new DraftReader(context);
    }

    private DraftReader(EventContext context) {
        this.context = context;
    }

    public Result executeMerged(CqnSelect select, Map<String, Object> cqnNamedValues) {
        if (select.orderBy().isEmpty() && !select.hasLimit()) {
            return this.executeMergedSimple(select, cqnNamedValues);
        }
        return this.executeMergedOrderedAndPaged(select, cqnNamedValues);
    }

    private Result executeMergedSimple(CqnSelect select, Map<String, Object> cqnNamedValues) {
        Result resultActive = ((DraftServiceImpl)this.context.getService()).readActive(select, cqnNamedValues);
        Result resultInactive = ((DraftServiceImpl)this.context.getService()).readDraft(select, cqnNamedValues);
        ArrayList merged = new ArrayList();
        resultActive.stream().forEach(merged::add);
        resultInactive.stream().forEach(merged::add);
        return ResultBuilder.selectedRows(merged).inlineCount(DraftReader.calcInlineCount(resultActive, resultInactive)).rowType(resultActive.rowType()).result();
    }

    private Result executeMergedOrderedAndPaged(CqnSelect select, Map<String, Object> cqnNamedValues) {
        long originalTop;
        CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)this.context.getModel(), (CqnSelect)select);
        LinkedHashMap<CqnSortSpecification, String> sortSpecificationToPath = this.ensureOrderByInColumns(select);
        SelectBuilder active = SelectBuilder.copyShallow((CqnSelect)select);
        SelectBuilder inactive = SelectBuilder.copyShallow((CqnSelect)select);
        inactive.limit(-1L, 0L);
        Result resultInactive = ((DraftServiceImpl)this.context.getService()).readDraft((CqnSelect)inactive, cqnNamedValues);
        long skipDiff = 0L;
        long l = originalTop = select.top() < 0L ? Long.MAX_VALUE : select.top();
        if (select.hasLimit()) {
            long draftsRead = resultInactive.rowCount();
            long originalSkip = select.skip();
            long newSkip = Math.max(0L, originalSkip - draftsRead);
            long newTop = Math.max(originalTop + draftsRead, originalTop);
            skipDiff = originalSkip - newSkip;
            active.limit(newTop, newSkip);
        }
        Result resultActive = ((DraftServiceImpl)this.context.getService()).readActive((CqnSelect)active, cqnNamedValues);
        List<Row> sortedRows = this.sortResults(resultActive, resultInactive, sortSpecificationToPath);
        if (select.hasLimit()) {
            long newEnd = Math.max(originalTop + skipDiff, originalTop);
            long end = Math.min(newEnd, (long)sortedRows.size());
            sortedRows = sortedRows.subList((int)skipDiff, (int)end);
        }
        if (sortSpecificationToPath.values().stream().anyMatch(value -> value.startsWith(ADDED_COLUMN_PREFIX))) {
            sortedRows.forEach(row -> row.keySet().removeIf(key -> key.startsWith(ADDED_COLUMN_PREFIX)));
        }
        return ResultBuilder.selectedRows(sortedRows).inlineCount(DraftReader.calcInlineCount(resultActive, resultInactive)).rowType(rowType).result();
    }

    private LinkedHashMap<CqnSortSpecification, String> ensureOrderByInColumns(CqnSelect select) {
        Map<String, String> selectColumnsToSearchableNames = CqnStatementUtils.resolveStar((CqnSelect)select, (CdsStructuredType)this.context.getTarget()).items().stream().flatMap(CqnSelectListItem::ofRef).collect(Collectors.toMap(CqnReference::path, CqnSelectListValue::displayName, (s, s2) -> s2));
        LinkedHashMap<CqnSortSpecification, String> pathLookup = new LinkedHashMap<CqnSortSpecification, String>(select.orderBy().size());
        ArrayList<CqnSelectListValue> newItems = new ArrayList<CqnSelectListValue>();
        int i = 0;
        for (CqnSortSpecification sortSpec : select.orderBy()) {
            Object displayName;
            CqnValue val = sortSpec.value();
            Object object = displayName = val.isRef() ? selectColumnsToSearchableNames.get(val.asRef().path()) : null;
            if (displayName == null) {
                displayName = ADDED_COLUMN_PREFIX + ++i;
                newItems.add(SelectListValueBuilder.select((CqnValue)val).as((String)displayName).build());
            }
            pathLookup.put(sortSpec, (String)displayName);
        }
        if (!newItems.isEmpty()) {
            newItems.addAll(0, select.items().isEmpty() ? Collections.singletonList(CQL.star()) : select.items());
            ((Select)select).columns(newItems);
        }
        return pathLookup;
    }

    private List<Row> sortResults(Result active, Result inactive, LinkedHashMap<CqnSortSpecification, String> sortSpecificationToPath) {
        if (active.rowCount() == 0L) {
            return inactive.list();
        }
        if (inactive.rowCount() == 0L) {
            return active.list();
        }
        ArrayList<Row> result = new ArrayList<Row>((int)(active.rowCount() + inactive.rowCount()));
        Iterator activeIter = active.iterator();
        Iterator draftIter = inactive.iterator();
        Row rActive = activeIter.hasNext() ? (Row)activeIter.next() : null;
        Row rDraft = draftIter.hasNext() ? (Row)draftIter.next() : null;
        Locale locale = this.context.getParameterInfo().getLocale();
        Collator collator = locale != null ? Collator.getInstance(locale) : null;
        Comparator cmp = (o1, o2) -> {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            for (Map.Entry entry : sortSpecificationToPath.entrySet()) {
                String item = (String)entry.getValue();
                int orderFactor = ((CqnSortSpecification)entry.getKey()).order() == CqnSortSpecification.Order.DESC ? -1 : 1;
                Object value1 = o1.getPath(item);
                Object value2 = o2.getPath(item);
                if (value1 == null && value2 == null) continue;
                if (value1 == null) {
                    return -orderFactor;
                }
                if (value2 == null) {
                    return orderFactor;
                }
                if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_SORT_ELEMENT, new Object[]{item, this.context.getTarget().getQualifiedName()});
                }
                int comp = value1 instanceof String && value2 instanceof String && collator != null ? collator.compare(value1, value2) : ((Comparable)value1).compareTo(value2);
                if (comp == 0) continue;
                return orderFactor * comp;
            }
            if (Boolean.TRUE.equals(o1.get((Object)"IsActiveEntity"))) {
                return Boolean.TRUE.equals(o2.get((Object)"IsActiveEntity")) ? 0 : 1;
            }
            return Boolean.TRUE.equals(o2.get((Object)"IsActiveEntity")) ? -1 : 0;
        };
        while (rActive != null || rDraft != null) {
            int comparison = Objects.compare(rDraft, rActive, cmp);
            if (comparison > 0) {
                result.add(rActive);
                rActive = activeIter.hasNext() ? (Row)activeIter.next() : null;
                continue;
            }
            result.add(rDraft);
            rDraft = draftIter.hasNext() ? (Row)draftIter.next() : null;
        }
        return result;
    }

    private static long calcInlineCount(Result r1, Result r2) {
        if (r1.inlineCount() >= 0L || r2.inlineCount() >= 0L) {
            return Math.max(0L, r1.inlineCount()) + Math.max(0L, r2.inlineCount());
        }
        return -1L;
    }
}

