/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.environment;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultEnvFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEnvFileUtils.class);
    private static final String DEFAULT_ENV = "default-env.json";
    private static final String CLASSPATH = "classpath:";

    DefaultEnvFileUtils() {
    }

    static String getDefaultEnv(CdsRuntime runtime) {
        InputStream stream = DefaultEnvFileUtils.getFromDefaultEnvPath(runtime.getEnvironment().getCdsProperties().getEnvironment().getLocal().getDefaultEnvPath());
        if (stream == null) {
            stream = DefaultEnvFileUtils.getClassLoaderResource(DEFAULT_ENV);
        }
        Path workingDirectory = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (stream == null) {
            stream = DefaultEnvFileUtils.getFromDirectory(workingDirectory, DEFAULT_ENV);
        }
        if (stream == null && workingDirectory.getParent() != null) {
            stream = DefaultEnvFileUtils.getFromDirectory(workingDirectory.getParent(), DEFAULT_ENV);
        }
        if (stream != null) {
            try (Scanner scanner = new Scanner(stream, StandardCharsets.UTF_8.name());){
                String string = scanner.useDelimiter("\\A").next();
                return string;
            }
        }
        return null;
    }

    private static InputStream getFromDirectory(Path workingDirectory, String fileName) {
        File defaultEnvFile = workingDirectory.resolve(fileName).toFile();
        if (defaultEnvFile.exists()) {
            try {
                logger.info("Loaded {} from directory '{}'", (Object)defaultEnvFile.getName(), (Object)defaultEnvFile.getParent());
                return new FileInputStream(defaultEnvFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static InputStream getFromDefaultEnvPath(String defaultEnvPath) {
        if (StringUtils.isEmpty((String)defaultEnvPath)) {
            return null;
        }
        if (defaultEnvPath.startsWith(CLASSPATH)) {
            return DefaultEnvFileUtils.getClassLoaderResource(defaultEnvPath.substring(CLASSPATH.length()));
        }
        File defaultEnvFile = new File(defaultEnvPath);
        if (defaultEnvFile.isDirectory()) {
            defaultEnvFile = Paths.get(defaultEnvPath, new String[0]).resolve(DEFAULT_ENV).toFile();
        }
        if (defaultEnvFile.exists()) {
            try {
                logger.info("Loaded {} from directory '{}'", (Object)defaultEnvFile.getName(), (Object)defaultEnvFile.getParent());
                return new FileInputStream(defaultEnvFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        logger.warn("No default env file found in configured path '{}'", (Object)defaultEnvPath);
        return null;
    }

    private static InputStream getClassLoaderResource(String resourceName) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (stream != null) {
            logger.info("Loaded {} from classpath resources", (Object)resourceName);
        }
        return stream;
    }
}

