/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.environment;

import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.impl.environment.DefaultEnvFileUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.environment.VcapServicesParser;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultServiceBindingProvider
implements ServiceBindingProvider {
    private final CdsRuntime runtime;
    private List<ServiceBinding> bindings;

    public DefaultServiceBindingProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Stream<ServiceBinding> get() {
        if (this.bindings == null) {
            this.bindings = this.loadBindings();
        }
        return this.bindings.stream();
    }

    private List<ServiceBinding> loadBindings() {
        List<ServiceBinding> bindings = DefaultServiceBindingAccessor.getInstance().getServiceBindings().stream().collect(Collectors.toList());
        if (bindings.isEmpty()) {
            return VcapServicesParser.getServiceBindings((String)DefaultEnvFileUtils.getDefaultEnv(this.runtime));
        }
        return bindings;
    }
}

