/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.impl.request.ParameterInfoFactory;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.request.RequestContextSPI;
import com.sap.cds.services.impl.request.UserInfoFactory;
import com.sap.cds.services.request.FeatureToggle;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ModifiableParameterInfo;
import com.sap.cds.services.request.ModifiableUserInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import io.opentelemetry.context.Context;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class RequestContextRunnerImpl
implements RequestContextRunner {
    private final CdsRuntime cdsRuntime;
    private final RequestContextSPI parentRequestContext;
    private final String parentTenant;
    private final Context parentTraceContext;
    private UserInfo userInfo;
    private ParameterInfo parameterInfo;
    private FeatureTogglesInfo featureTogglesInfo;
    private AuthenticationInfo authenticationInfo;
    private boolean clearMessages = false;

    public RequestContextRunnerImpl(CdsRuntime cdsRuntime) {
        this.cdsRuntime = Objects.requireNonNull(cdsRuntime, "cdsRuntime must not be null");
        this.parentRequestContext = RequestContextImpl.getCurrentInternal();
        if (this.parentRequestContext != null) {
            this.parentTenant = this.parentRequestContext.getUserInfo().getTenant();
            this.userInfo = this.parentRequestContext.getUserInfo();
            this.parameterInfo = this.parentRequestContext.getParameterInfo();
            this.featureTogglesInfo = this.parentRequestContext.getFeatureTogglesInfo();
            this.authenticationInfo = this.parentRequestContext.getAuthenticationInfo();
        } else {
            this.parentTenant = null;
            this.userInfo = this.providedUserInfo();
            this.parameterInfo = this.providedParameterInfo();
            this.featureTogglesInfo = null;
            this.authenticationInfo = cdsRuntime.getProvidedAuthenticationInfo();
        }
        assert (this.userInfo != null);
        assert (this.parameterInfo != null);
        this.parentTraceContext = Context.current();
    }

    public RequestContextRunner user(UserInfo userInfo) {
        Objects.requireNonNull(userInfo, "userInfo must not be null");
        this.userInfo = userInfo;
        return this;
    }

    public RequestContextRunner anonymousUser() {
        this.userInfo = UserInfoFactory.anonymousUserInfo();
        return this;
    }

    public RequestContextRunner providedUser() {
        this.userInfo = this.providedUserInfo();
        return this;
    }

    public RequestContextRunner privilegedUser() {
        String tenant = this.userInfo.getTenant();
        Map additionalAttributes = this.userInfo.getAdditionalAttributes();
        this.userInfo = UserInfoFactory.privilegedUserInfo();
        this.modifyUser(u -> u.setTenant(tenant).setAdditionalAttributes(additionalAttributes));
        return this;
    }

    public RequestContextRunner modifyUser(Consumer<ModifiableUserInfo> contextUser) {
        UserInfo prevUserInfo = this.userInfo;
        ModifiableUserInfo modifiedUser = prevUserInfo.copy();
        if (contextUser != null) {
            contextUser.accept(modifiedUser);
        }
        this.userInfo = modifiedUser;
        return this;
    }

    public RequestContextRunner parameters(ParameterInfo parameterInfo) {
        Objects.requireNonNull(parameterInfo, "parameterInfo must not be null");
        this.parameterInfo = parameterInfo;
        return this;
    }

    public RequestContextRunner featureToggles(FeatureTogglesInfo featureTogglesInfo) {
        Objects.requireNonNull(featureTogglesInfo, "featureTogglesInfo must not be null");
        if (this.parentRequestContext != null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FEATURETOGGLESINFO_OVERRIDE, new Object[0]);
        }
        this.featureTogglesInfo = featureTogglesInfo;
        return this;
    }

    public RequestContextRunner clearParameters() {
        this.parameterInfo = ParameterInfoFactory.emptyParameterInfo();
        return this;
    }

    public RequestContextRunner providedParameters() {
        this.parameterInfo = this.providedParameterInfo();
        return this;
    }

    public RequestContextRunner modifyParameters(Consumer<ModifiableParameterInfo> contextParamters) {
        ParameterInfo prevParameterInfo = this.parameterInfo;
        ModifiableParameterInfo modifiedParameter = prevParameterInfo.copy();
        if (contextParamters != null) {
            contextParamters.accept(modifiedParameter);
        }
        this.parameterInfo = modifiedParameter;
        return this;
    }

    public RequestContextRunner clearMessages() {
        this.clearMessages = true;
        return this;
    }

    public void run(Consumer<RequestContext> requestHandler) {
        this.run((RequestContext requestContext) -> {
            requestHandler.accept((RequestContext)requestContext);
            return Void.TYPE;
        });
    }

    /*
     * Exception decompiling
     */
    public <T> T run(Function<RequestContext, T> requestHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private UserInfo providedUserInfo() {
        UserInfo result = this.cdsRuntime.getProvidedUserInfo();
        if (result != null) {
            return result;
        }
        return UserInfoFactory.anonymousUserInfo();
    }

    private ParameterInfo providedParameterInfo() {
        ParameterInfo result = this.cdsRuntime.getProvidedParameterInfo();
        if (result != null) {
            return result;
        }
        return ParameterInfoFactory.emptyParameterInfo();
    }

    private FeatureTogglesInfo calculateFeatureTogglesInfo() {
        FeatureTogglesInfo result = this.cdsRuntime.getFeatureTogglesInfo(this.userInfo, this.parameterInfo);
        if (result != null) {
            return result;
        }
        return FeatureTogglesInfo.create((FeatureToggle[])new FeatureToggle[0]);
    }
}

