/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.ValidatorUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Objects;
import java.util.function.Predicate;

public class NotNullHandlerDelegate {
    @VisibleForTesting
    public static Predicate<CdsElement> requiresNotNullCheck() {
        return element -> {
            if (!ValidatorUtils.requiresNotNullCheck(element)) {
                return false;
            }
            if (!element.isNotNull() || !CdsAnnotations.ASSERT_NOTNULL.isTrue((CdsAnnotatable)element)) {
                return false;
            }
            return CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrValue((CdsAnnotatable)element, null) == null;
        };
    }

    public void accept(EventContext context, boolean allowMessageCollection) {
        ValidatorUtils.runNotNullCheck(context, NotNullHandlerDelegate.requiresNotNullCheck(), ValidatorUtils.assertNotNull(context, Objects::isNull, (path, element, entity) -> {
            if (CdsModelUtils.isInternalOperationType(element.getDeclaringType().as(CdsDefinition.class))) {
                if (!allowMessageCollection) throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_VALUE, new Object[]{element.getName()}).messageTarget(path, element);
                ValidatorUtils.handleValidationError(context, path, element, CdsErrorStatuses.MISSING_VALUE, element.getName());
                return;
            } else {
                if (!allowMessageCollection) throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_REQUIRED, new Object[]{element.getName(), entity}).messageTarget(path, element);
                ValidatorUtils.handleValidationError(context, path, element, CdsErrorStatuses.VALUE_REQUIRED, element.getName(), entity);
            }
        }));
    }
}

