/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.services.impl.changeset.ChangeSetContextImpl;
import com.sap.cds.services.impl.request.RequestContextSPI;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Context;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class OpenTelemetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetryUtils.class);
    private static final String CDS_INSTRUMENTATION_SCOPE = "com.sap.cds";
    private static Tracer tracer = GlobalOpenTelemetry.get().getTracer("com.sap.cds");

    private OpenTelemetryUtils() {
    }

    public static Optional<Span> createSpan(CdsSpanType type) {
        return OpenTelemetryUtils.createSpan(type, null);
    }

    public static Optional<Span> createSpan(CdsSpanType type, Context parentContext) {
        if (logger.isEnabledForLevel(type.getLogLevel())) {
            SpanBuilder spanBuilder = tracer.spanBuilder(type.toString());
            if (!OpenTelemetryUtils.isValidContext(Context.current()) && parentContext != null) {
                spanBuilder.setParent(parentContext);
            }
            return Optional.of(spanBuilder.startSpan());
        }
        return Optional.empty();
    }

    private static boolean isValidContext(Context ctx) {
        Span span = Span.fromContext((Context)ctx);
        return TraceId.isValid((CharSequence)span.getSpanContext().getTraceId()) && SpanId.isValid((CharSequence)span.getSpanContext().getSpanId());
    }

    public static void updateSpan(Optional<Span> span, String serviceName, String eventName, String entityName) {
        span.ifPresent(s -> {
            s.updateName(serviceName + " (" + eventName + ")");
            s.setAttribute("cds.service", String.valueOf(serviceName));
            s.setAttribute("cds.eventName", String.valueOf(eventName));
            s.setAttribute("cds.entityName", String.valueOf(entityName));
        });
    }

    public static void updateSpan(Optional<Span> span, RequestContextSPI requestContext) {
        span.ifPresent(s -> {
            s.updateName("RequestContext " + requestContext.getId());
            s.setAttribute("cds.tenant", String.valueOf(requestContext.getUserInfo().getTenant()));
            s.setAttribute("cds.systemUser", String.valueOf(requestContext.getUserInfo().isSystemUser()));
            s.setAttribute("cds.internalUser", String.valueOf(requestContext.getUserInfo().isInternalUser()));
            s.setAttribute("cds.privilegedUser", String.valueOf(requestContext.getUserInfo().isPrivileged()));
            s.setAttribute("cds.locale", String.valueOf(requestContext.getParameterInfo().getLocale()));
            s.setAttribute("cds.validFrom", String.valueOf(requestContext.getParameterInfo().getValidFrom()));
            s.setAttribute("cds.validTo", String.valueOf(requestContext.getParameterInfo().getValidTo()));
        });
    }

    public static void updateSpan(Optional<Span> span, ChangeSetContextImpl changeSetContext) {
        span.ifPresent(s -> s.updateName("ChangeSetContext " + changeSetContext.getId()));
    }

    public static void endSpan(Optional<Span> span) {
        span.ifPresent(Span::end);
    }

    public static void recordException(Optional<Span> span, Exception e) {
        span.ifPresent(s -> {
            s.recordException((Throwable)e);
            s.setStatus(StatusCode.ERROR);
        });
    }

    @VisibleForTesting
    public static void setTracerProvider(TracerProvider tracerProvider) {
        tracer = tracerProvider.tracerBuilder(CDS_INSTRUMENTATION_SCOPE).setInstrumentationVersion("1.0.0").build();
    }

    public static enum CdsSpanType {
        REQUEST_CONTEXT(Level.INFO),
        CHANGESET_CONTEXT(Level.INFO),
        EMIT(Level.DEBUG);

        private final Level logLevel;

        private CdsSpanType(Level logLevel) {
            this.logLevel = logLevel;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }
    }
}

