/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import java.util.Objects;

import org.slf4j.helpers.MessageFormatter;

import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class ValidatorErrorUtils {

	private ValidatorErrorUtils() {
		// empty
	}

	public static void handleValidationError(EventContext context, Path path, CdsElement element,
			CdsErrorStatuses statuses, Object... args) {
		handleValidationError(context, false, path, element, statuses, args);
	}

	public static void handleValidationError(EventContext context, boolean forceException, Path path,
			CdsElement element, CdsErrorStatuses statuses, Object... args) {
		if (!forceException && context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
			context.getMessages().error(getLocalizedMessage(context, statuses, args)).code(statuses.getCodeString())
					.target(path, element);
		} else {
			throw new ErrorStatusException(statuses, args).messageTarget(path, element);
		}
	}

	private static String getLocalizedMessage(EventContext context, ErrorStatus errorStatus, Object... args) {
		String localized = context.getCdsRuntime().getLocalizedMessage(errorStatus.getCodeString(), args,
				context.getParameterInfo().getLocale());

		if (Objects.equals(localized, errorStatus.getCodeString())) {
			return MessageFormatter.arrayFormat(errorStatus.getDescription(), args).getMessage();
		}
		return localized;
	}

}
