/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.draft.ActiveReadEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.draft.CqnAdapter;
import com.sap.cds.services.impl.draft.DraftActivesReader;
import com.sap.cds.services.impl.draft.DraftHandlerUtils;
import com.sap.cds.services.impl.draft.DraftInactivesReader;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.model.CqnUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={DraftService.class})
public class ActiveHandler
implements EventHandler {
    @Before(event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=-10600)
    protected void clearDraftFields(EventContext context) {
        CdsServiceUtils.getEntities(context).forEach(r -> CdsModelUtils.visitDeep(context.getTarget(), r, (cdsEntity, data, parent, parentData) -> {
            data.remove("HasDraftEntity");
            data.remove("HasActiveEntity");
            data.remove("SiblingEntity");
            data.remove("DraftAdministrativeData");
            data.remove("DraftAdministrativeData_DraftUUID");
            if (parentData != null && !data.values().stream().anyMatch(e -> e != null)) {
                parentData.remove(parent.getName());
            }
        }));
    }

    @Before(event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=11200)
    protected void clearIsActiveEntity(EventContext context) {
        CdsDataProcessor.create().addConverter((p, e, t) -> e.getName().equals("IsActiveEntity"), (p, e, v) -> CdsDataProcessor.Converter.REMOVE).process(CdsServiceUtils.getEntities(context), (CdsStructuredType)context.getTarget());
    }

    @Before(service={"*"}, serviceType={PersistenceService.class}, event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=-10600)
    protected void clearDraftFieldsOnPersistenceService(EventContext context) {
        if (DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget()) && !context.getTarget().getQualifiedName().endsWith("_drafts")) {
            this.clearDraftFields(context);
        }
    }

    @After(event={"CREATE", "UPSERT", "UPDATE"})
    @HandlerOrder(value=-11000)
    protected void addActiveDraftFields(EventContext context) {
        List result = CdsServiceUtils.getResult(context).list();
        CdsModelUtils.visitDeep(context.getTarget(), result, (cdsEntity, data, parent) -> {
            if (DraftUtils.isDraftEnabled((CdsAnnotatable)cdsEntity)) {
                data.forEach(m -> {
                    m.put("IsActiveEntity", true);
                    m.put("HasActiveEntity", false);
                    m.put("HasDraftEntity", false);
                });
            }
        });
    }

    @Before(event={"ACTIVE_READ", "UPDATE", "DELETE"})
    @HandlerOrder(value=11300)
    protected void adaptForActiveExecution(EventContext context) {
        if (context.getEvent().equals("ACTIVE_READ") || DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
            CqnStatement statement = (CqnStatement)context.get("cqn");
            if (!statement.isSelect()) {
                statement = this.addLockingConstraints(statement, context);
            }
            if ((statement = CqnAdapter.create(context).adaptForActiveExecution(statement)) == null || !statement.isSelect() && this.isTargetingLocked(statement, context)) {
                context.put("result", (Object)DraftHandlerUtils.buildNoOpResult(context));
                context.setCompleted();
            } else {
                context.put("cqn", (Object)statement);
            }
        }
    }

    @Before
    @HandlerOrder(value=11301)
    protected void selectRelatedDraftsBeforeDelete(CdsDeleteEventContext context) {
        if (DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
            context.put("relatedDraftUuids", this.selectRelatedDraftUuids(context.getCqn(), context));
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultRead(ActiveReadEventContext context) {
        return CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run(context.getCqn(), context.getCqnNamedValues());
    }

    @After
    protected void deleteRelatedDrafts(CdsDeleteEventContext context) {
        if (DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget()) && context.getResult().rowCount() > 0L) {
            DraftService service = (DraftService)context.getService();
            List draftKeysToDelete = (List)context.get("relatedDraftUuids");
            context.put("relatedDraftUuids", null);
            Result deletedDrafts = (Result)context.getCdsRuntime().requestContext().privilegedUser().run(requestContext -> {
                if (draftKeysToDelete != null) {
                    long[] rowCount = draftKeysToDelete.stream().mapToLong(item -> {
                        if (!item.isEmpty()) {
                            return service.cancelDraft((CqnDelete)Delete.from((CdsEntity)context.getTarget()).where(c -> c.to("DraftAdministrativeData").anyMatch(d -> d.get("DraftUUID").in(item))), new Object[0]).rowCount();
                        }
                        return 0L;
                    }).toArray();
                    return ResultBuilder.deletedRows((long[])rowCount).result();
                }
                return service.cancelDraft(context.getCqn(), context.getCqnValueSets());
            });
            context.setResult((Iterable)ResultBuilder.deletedRows((long[])this.addRowCounts(context.getResult(), deletedDrafts)).result());
        }
    }

    private <T extends CqnStatement> T addLockingConstraints(T statement, EventContext context) {
        CdsProperties properties = context.getCdsRuntime().getEnvironment().getCdsProperties();
        if (!properties.getSecurity().getAuthorization().getDraftProtection().isEnabled().booleanValue() || "split".equals(DraftHandlerUtils.getDraftPersistenceMode(context))) {
            return statement;
        }
        CdsEntity draftEntity = DraftModifier.getDraftsEntity(context.getTarget(), context.getModel());
        CqnPredicate sameKeys = (CqnPredicate)context.getTarget().keyElements().filter(e -> !e.getType().isAssociation() && !e.isVirtual() && !e.getName().equals("IsActiveEntity")).map(key -> CQL.to((String)"$outer").get(key.getName()).eq((Value)CQL.get((String)key.getName()))).collect(CQL.withAnd());
        if (statement.isDelete()) {
            sameKeys = CQL.and((CqnPredicate)sameKeys, (CqnPredicate)DraftActivesReader.ownedbyAnotherUser(true, context));
        }
        return (T)CqnUtils.addWhere(statement, (CqnPredicate)CQL.exists((CqnSelect)Select.from((CdsEntity)draftEntity).where(sameKeys)).not());
    }

    private boolean isTargetingLocked(CqnStatement statement, EventContext context) {
        Iterable valueSets;
        Select select;
        CdsProperties properties = context.getCdsRuntime().getEnvironment().getCdsProperties();
        if (!properties.getSecurity().getAuthorization().getDraftProtection().isEnabled().booleanValue() || !"split".equals(DraftHandlerUtils.getDraftPersistenceMode(context))) {
            return false;
        }
        if (statement.isUpdate()) {
            select = CqnUtils.toSelect((CqnUpdate)statement.asUpdate(), (CdsEntity)context.getTarget());
            valueSets = ((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getCqnValueSets();
        } else if (statement.isDelete()) {
            select = (Select)CqnUtils.addWhere((CqnStatement)CqnUtils.toSelect((CqnDelete)statement.asDelete()), (CqnPredicate)DraftActivesReader.ownedbyAnotherUser(true, context));
            valueSets = ((CdsDeleteEventContext)context.as(CdsDeleteEventContext.class)).getCqnValueSets();
        } else {
            return false;
        }
        Select draftExists = select.columns(new Selectable[]{CQL.constant((Object)1).as("one")}).limit(1L);
        Iterator iterator = valueSets.iterator();
        if (!iterator.hasNext()) {
            return DraftInactivesReader.create(context).draftsOfAllUsers((CqnSelect)draftExists).rowCount() > 0L;
        }
        while (iterator.hasNext()) {
            if (DraftInactivesReader.create(context).draftsOfAllUsers((CqnSelect)draftExists, (Map)iterator.next()).rowCount() <= 0L) continue;
            return true;
        }
        return false;
    }

    private long[] addRowCounts(Result ... results) {
        long[] result = new long[]{};
        for (Result r : results) {
            if (r == null) continue;
            if (result.length == 0) {
                result = new long[r.batchCount()];
            }
            for (int i = 0; i < result.length; ++i) {
                int n = i;
                result[n] = result[n] + r.rowCount(i);
            }
        }
        return result;
    }

    private List<List<?>> selectRelatedDraftUuids(CqnDelete delete, CdsDeleteEventContext context) {
        if (delete.where().isPresent() || delete.ref().targetSegment().filter().isPresent()) {
            SelectBuilder select = delete.where().map(condition -> ActiveHandler.selectDraftID(delete.ref()).where(w -> condition)).orElse(ActiveHandler.selectDraftID(delete.ref())).filter((CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)true));
            if (context.getCqnValueSets().iterator().hasNext()) {
                ArrayList result = new ArrayList();
                context.getCqnValueSets().forEach(arg_0 -> ActiveHandler.lambda$selectRelatedDraftUuids$17(result, context, (CqnSelect)select, arg_0));
                return result;
            }
            return Collections.singletonList(context.getService().run((CqnSelect)select, new Object[0]).streamOf(Drafts.class).map(r -> r.getDraftAdministrativeData()).filter(Objects::nonNull).map(d -> d.getDraftUUID()).filter(Objects::nonNull).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return null;
    }

    private static SelectBuilder<StructuredType<?>> selectDraftID(CqnStructuredTypeRef ref) {
        return (SelectBuilder)Select.from((CqnStructuredTypeRef)ref).columns(new String[]{"DraftAdministrativeData"});
    }

    private static /* synthetic */ void lambda$selectRelatedDraftUuids$17(List result, CdsDeleteEventContext context, CqnSelect select, Map parameters) {
        result.add(context.getService().run(select, parameters).streamOf(Drafts.class).map(r -> r.getDraftAdministrativeData()).filter(Objects::nonNull).map(d -> d.getDraftUUID()).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

