/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime.mockusers;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.ClassMethods;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MockedUserInfo
implements UserInfo {
    private final CdsProperties.Security.Mock.User mockedUser;
    private final String userId;
    private final Set<String> roles;
    private final Map<String, List<String>> attributes;
    private static final String SPECIAL_ATTRIBUTE_TENANT = "tenant";

    public MockedUserInfo(CdsProperties.Security.Mock.User mockedUser) {
        this.mockedUser = mockedUser;
        this.userId = mockedUser.getId() == null ? "mock/" + mockedUser.getName() : mockedUser.getId();
        this.roles = new TreeSet<String>(mockedUser.getRoles());
        this.attributes = new TreeMap<String, List<String>>(mockedUser.getAttributes());
        this.attributes.put(SPECIAL_ATTRIBUTE_TENANT, Collections.singletonList(mockedUser.getTenant()));
    }

    public String getId() {
        return this.userId;
    }

    public String getName() {
        return this.mockedUser.getName();
    }

    public String getTenant() {
        return this.mockedUser.getTenant();
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean isSystemUser() {
        return this.mockedUser.isSystemUser() || this.isInternalUser();
    }

    public boolean isInternalUser() {
        return this.mockedUser.isInternalUser();
    }

    public boolean isAuthenticated() {
        return true;
    }

    public boolean isPrivileged() {
        return this.mockedUser.isPrivileged();
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @Deprecated
    public Set<String> getUnrestrictedAttributes() {
        return new TreeSet<String>(this.mockedUser.getUnrestricted());
    }

    public Map<String, Object> getAdditionalAttributes() {
        return this.mockedUser.getAdditional();
    }

    public <T extends UserInfo> T as(Class<T> userInfoClazz) {
        return (T)((UserInfo)ClassMethods.as(userInfoClazz, UserInfo.class, (Object)this, this::getAdditionalAttributes));
    }

    public String toString() {
        return MessageFormat.format("MockedUserInfo [id=''{0}'', name=''{1}'', roles=''{2}'', attributes=''{3}''", this.getId(), this.getName(), this.getRoles(), this.getAttributes());
    }
}

