/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.ContextualizedServiceException;
import java.util.ArrayList;

public class DeveloperModeUtils {
    private DeveloperModeUtils() {
    }

    public static void extendMessage(StringBuilder builder, ContextualizedServiceException contextualizedException) {
        EventContext errorContext = contextualizedException.getErrorContext();
        builder.append("\n\tParameters from context:");
        for (String key : errorContext.keySet()) {
            builder.append("\n\t").append(key).append(" = '").append(errorContext.get(key).toString()).append("'");
        }
        for (Object exception = contextualizedException; exception != null; exception = ((Throwable)exception).getCause()) {
            if (!(exception instanceof ContextualizedServiceException)) continue;
            ContextualizedServiceException contextualized = exception;
            ArrayList<EventContext> viaList = new ArrayList<EventContext>();
            if (!((Object)((Object)contextualized)).equals((Object)contextualizedException)) {
                viaList.add(contextualized.getErrorContext());
            }
            viaList.addAll(contextualized.getViaList());
            for (EventContext via : viaList) {
                builder.append("\n\tvia service '").append(via.getService().getName()).append("', ");
                builder.append("event '").append(via.getEvent()).append("', ");
                if (via.getTarget() == null) continue;
                builder.append("entity '").append(via.getTarget().getQualifiedName()).append("'");
            }
        }
    }
}

