/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Iterator;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class CapabilitiesHandler
implements EventHandler {
    @Before(event={"READ"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityRead(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isReadable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_READABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"CREATE", "UPSERT"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityCreate(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isInsertable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INSERTABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"UPDATE", "UPSERT"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityUpdate(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isUpdatable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_UPDATABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"DELETE"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityDelete(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isDeletable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_DELETABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    public static Capabilities getCapabilities(EventContext context) {
        CdsEntity entity = context.getTarget();
        CqnStatement cqn = (CqnStatement)context.get("cqn");
        if (CapabilitiesHandler.isInvalidAutoExposedRootEntity(cqn, context.getModel())) {
            return new Capabilities(false, false, false, false);
        }
        if (CapabilitiesHandler.isExplicitlyAutoExposedTargetEntity(cqn, context.getModel())) {
            return new Capabilities(true, false, false, false);
        }
        boolean readonly = CdsAnnotations.READONLY.isTrue((CdsAnnotatable)entity);
        if (readonly) {
            return new Capabilities(true, false, false, false);
        }
        boolean insertOnly = CdsAnnotations.INSERTONLY.isTrue((CdsAnnotatable)entity);
        if (insertOnly) {
            return new Capabilities(false, true, false, false);
        }
        boolean insertable = CapabilitiesHandler.defaultToTrue(CdsAnnotations.INSERTABLE.getOrDefault((CdsAnnotatable)entity));
        boolean updatable = CapabilitiesHandler.defaultToTrue(CdsAnnotations.UPDATABLE.getOrDefault((CdsAnnotatable)entity));
        boolean deletable = CapabilitiesHandler.defaultToTrue(CdsAnnotations.DELETABLE.getOrDefault((CdsAnnotatable)entity));
        boolean readable = CapabilitiesHandler.defaultToTrue(CdsAnnotations.READABLE.getOrDefault((CdsAnnotatable)entity));
        return new Capabilities(readable, insertable, updatable, deletable);
    }

    private static boolean defaultToTrue(Object value) {
        if (value instanceof Boolean) {
            Boolean boolean1 = (Boolean)value;
            return boolean1;
        }
        if (value instanceof String) {
            String string = (String)value;
            return !string.equalsIgnoreCase("false");
        }
        return true;
    }

    private static boolean isInvalidAutoExposedRootEntity(CqnStatement cqn, CdsModel model) {
        if (cqn.isSelect() && cqn.asSelect().from().isSelect()) {
            return CapabilitiesHandler.isInvalidAutoExposedRootEntity((CqnStatement)cqn.asSelect().from().asSelect(), model);
        }
        CdsEntity rootEntity = com.sap.cds.services.utils.model.CdsModelUtils.getEntityPath((CqnStructuredTypeRef)cqn.ref(), (CdsModel)model).rootEntity();
        boolean autoexposed = CdsAnnotations.AUTOEXPOSED.isTrue((CdsAnnotatable)rootEntity);
        boolean autoexpose = CdsAnnotations.AUTOEXPOSE.isTrue((CdsAnnotatable)rootEntity);
        return (autoexposed || CdsModelUtils.isGeneratedByCompiler(rootEntity)) && !autoexpose && !DraftUtils.isDraftEnabled((CdsAnnotatable)rootEntity);
    }

    private static boolean isExplicitlyAutoExposedTargetEntity(CqnStatement cqn, CdsModel model) {
        if (cqn.isSelect() && cqn.asSelect().from().isSelect()) {
            return CapabilitiesHandler.isExplicitlyAutoExposedTargetEntity((CqnStatement)cqn.asSelect().from().asSelect(), model);
        }
        Iterator reverse = com.sap.cds.services.utils.model.CdsModelUtils.getEntityPath((CqnStructuredTypeRef)cqn.ref(), (CdsModel)model).reverse();
        while (reverse.hasNext()) {
            CdsEntity entity = ((ResolvedSegment)reverse.next()).entity();
            boolean autoexposed = CdsAnnotations.AUTOEXPOSED.isTrue((CdsAnnotatable)entity);
            boolean autoexpose = CdsAnnotations.AUTOEXPOSE.isTrue((CdsAnnotatable)entity);
            if (!autoexposed) break;
            if (!autoexpose || entity.getQualifiedName().endsWith("_texts") || entity.getQualifiedName().endsWith(".texts")) continue;
            return true;
        }
        return false;
    }

    public static class Capabilities {
        private boolean readable;
        private boolean insertable;
        private boolean updatable;
        private boolean deletable;

        private Capabilities(boolean readable, boolean insertable, boolean updatable, boolean deletable) {
            this.readable = readable;
            this.insertable = insertable;
            this.updatable = updatable;
            this.deletable = deletable;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public boolean isInsertable() {
            return this.insertable;
        }

        public boolean isUpdatable() {
            return this.updatable;
        }

        public boolean isDeletable() {
            return this.deletable;
        }
    }
}

