/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.Service;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.outbox.CqnServiceOutboxHandler;
import com.sap.cds.services.impl.outbox.InMemoryOutbox;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutbox;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutboxInitializationHandler;
import com.sap.cds.services.impl.outbox.persistence.collectors.TenantCache;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.outbox.OutboxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboxServiceConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OutboxServiceConfiguration.class);
    private final TenantCache tenantCache = new TenantCache();

    public void services(CdsRuntimeConfigurer configurer) {
        CdsRuntime runtime = configurer.getCdsRuntime();
        if (OutboxUtils.hasOutboxModel((CdsModel)runtime.getCdsModel())) {
            runtime.getEnvironment().getCdsProperties().getOutbox().getServices().values().forEach(config -> {
                boolean ordered = this.getOrderedFlag((CdsProperties.Outbox.OutboxServiceConfig)config);
                configurer.service((Service)new PersistentOutbox(config.getName(), (CdsProperties.Outbox.OutboxConfig)config, ordered, runtime, this.tenantCache::getTenants));
            });
            CdsProperties.Outbox.Persistent defaultConfig = runtime.getEnvironment().getCdsProperties().getOutbox().getPersistent();
            if (defaultConfig.isEnabled()) {
                if (runtime.getServiceCatalog().getService(OutboxService.class, "DefaultOutboxOrdered") == null) {
                    configurer.service((Service)new PersistentOutbox("DefaultOutboxOrdered", (CdsProperties.Outbox.OutboxConfig)defaultConfig, true, runtime, this.tenantCache::getTenants));
                }
                if (runtime.getServiceCatalog().getService(OutboxService.class, "DefaultOutboxUnordered") == null) {
                    configurer.service((Service)new PersistentOutbox("DefaultOutboxUnordered", (CdsProperties.Outbox.OutboxConfig)defaultConfig, false, runtime, this.tenantCache::getTenants));
                }
            }
        } else if (!runtime.getEnvironment().getCdsProperties().getOutbox().getServices().isEmpty()) {
            logger.warn("Explicitly configured outbox services will not be available, because persistent outbox model is not available.");
        }
        if (runtime.getEnvironment().getCdsProperties().getOutbox().getInMemory().isEnabled().booleanValue()) {
            configurer.service((Service)new InMemoryOutbox("OutboxService$InMemory", runtime));
        }
    }

    private boolean getOrderedFlag(CdsProperties.Outbox.OutboxServiceConfig config) {
        if ("DefaultOutboxOrdered".equals(config.getName())) {
            return true;
        }
        if ("DefaultOutboxUnordered".equals(config.getName())) {
            return false;
        }
        return config.isOrdered();
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        if (configurer.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).findAny().isPresent()) {
            configurer.eventHandler((Object)new PersistentOutboxInitializationHandler(this.tenantCache));
        }
        configurer.eventHandler((Object)new CqnServiceOutboxHandler());
    }

    public int order() {
        return -100;
    }
}

