/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.auditlog;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.auditlog.event.TenantOffboardedEventContext;
import com.sap.cds.services.auditlog.event.TenantOnboardedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.OrderConstants;

/**
 * An {@link EventHandler} to handle auditlog related events.
 */
@ServiceName(value = "*", type = AuditLogService.class)
class AuditLogDefaultOnHandler implements EventHandler {

	private static final Logger LOG = LoggerFactory.getLogger(AuditLogDefaultOnHandler.class);

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	public void handleDataAccessEvent(DataAccessLogContext context) {
		if (LOG.isDebugEnabled()) {
			LOG.debug("DataAccess: {}", context.getData().toJson());
		}
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	public void handleDataModificationEvent(DataModificationLogContext context) {
		if (LOG.isDebugEnabled()) {
			LOG.debug("DataModification: {}", context.getData().toJson());
		}
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	public void handleConfigChangeEvent(ConfigChangeLogContext context) {
		if (LOG.isDebugEnabled()) {
			LOG.debug("ConfigChange: {}", context.getData().toJson());
		}
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	public void handleSecurityEvent(SecurityLogContext context) {
		if (LOG.isDebugEnabled()) {
			LOG.debug("SecurityEvent: {}", context.getData().toJson());
		}
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	public void handleTenantOnboardedEvent(TenantOnboardedEventContext context) {
		if (LOG.isDebugEnabled() && context.get("data") != null) {
			LOG.debug("Tenant onboarded: {}", context.get("data"));
		}
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	public void handleTenantOffboardedEvent(TenantOffboardedEventContext context) {
		if (LOG.isDebugEnabled() && context.get("data") != null) {
			LOG.debug("Tenant offboarded: {}",  context.get("data"));
		}
	}
}
